/***********************************
name:   PCF8563.h      Version: 0.3
author: PE HTL BULME
email:  pe@bulme.at
description:
    Definition portion of the class rtc


***********************************/

#include "mbed.h"
#include "const.h"

#if !defined (PCF8563_H)
#define PCF8563_H

/** PCF8563 Class
 */
 
 /** 
name:   rtc.h      Version: 0.1
author: PE HTL BULME
email:  pe@bulme.at
description:
    Definition portion of the class rtc


***********************************/
class PCF8563
{
protected:
    //PinName _sda, _scl;     
    I2C i2c;                    /**< I2C definition */
    char week_val;

    /**
    protected methodes for internal purposes only
    */
    void error();               /**< Error: stops and all LEDs are blinking*/

public:
    /** Create a RTC object connected to the specified pin
    * @param pin sda/scl pin to connect to
    */
    PCF8563();                          /**< default constructor; sda(p28), sdc(p27) */
    PCF8563(PinName sda, PinName scl);  /**< parameterized constructor with sda-pin, sdc-pin)*/
    ~PCF8563();
    char read(char address);    /**< read value from I2C bus; ToDo --> Error()*/ 
    void write(char address, char value);   /**< write value to I2C bus; ToDo --> Error()*/ 
    void init();                /**< initialize the RTC to a given date and time; ToDo --> Error()*/ 
    void alarm();
};

#endif