/***********************************
name:   PCF8563.cpp    Version: 0.3
author: PE HTL BULME
email:  pe@bulme.at
description:
    Implementation portion of class rtc 
    real time clock on himbed0
      
***********************************/

#include "mbed.h"
#include "const.h"
#include "PCF8563.h"

PCF8563::~PCF8563()
{}

// Default constructor
PCF8563::PCF8563() : i2c(p28, p27)              // HIMBED M0
{
    i2c.frequency(40000);               // I2C Frequenz 40kHz
    char init1[2] = {0x6, 0x00};
    char init2[2] = {0x7, 0xff};
    i2c.write(0x40, init1, 2);
    i2c.write(0x40, init2, 2);

}

// Param. constructor with pins sda and scl
PCF8563::PCF8563(PinName sda, PinName scl) :  i2c(sda, scl)  //_sda(sda), _scl(scl)   // no I2C default constructor
{
    i2c.frequency(40000);               // I2C Frequenz 40kHz
    char init1[2] = {0x6, 0x00};
    char init2[2] = {0x7, 0xff};
    i2c.write(0x40, init1, 2);
    i2c.write(0x40, init2, 2);
}

char PCF8563::read(char address)
{
    char value;
    i2c.start();
    //i2c.write(PCF8563_ADR_RD, &address, true);
    i2c.write(PCF8563_ADR_WR);
    i2c.write(address);
    i2c.start();
    i2c.write(PCF8563_ADR_RD);
    value = i2c.read(0);
    i2c.stop();
    return value;
}
void PCF8563::write(char address, char value)
{
    i2c.start();
    //i2c.write(PCF8563_ADR_WR, &address, value, true);
    i2c.write(PCF8563_ADR_WR);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}

void PCF8563::init()
{
    // Format
    // 2015/03/31
    // 22:10:00

    week_val = 0x01;                // Tu
    write(CONTROL1, 0x20);      // stop
    write(CONTROL2, 0x00);
    write(YEARS, (0x15));
    write(MONTHS, (0x03));
    write(DAYS, (0x31));
    write(HOURS, (0x22));
    write(MINUTES, (0x10));
    write(SECONDS, (0x00));
    write(WEEKDAYS, week_val);
    write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    write(TIMER_CINTROL, 0x00);
    write(CONTROL1, 0x00);      // start
}

void PCF8563::alarm()   // Setting up RTC alarm
{
    write(CONTROL1, 0x20);      // stop
    write(CONTROL2, 0x02);      // AIE - alarm interrupt enabled
    write(DAY_ALARM, (0x80) );
    write(HOUR_ALARM, (0x97));
    write(MINUTE_ALARM, (0x02));
    write(WEEKDAY_ALARM, (0x80));
    write(CONTROL1, 0x00);      // start
}

//-----------------INTERNAL USE ONLY ----------------------------
void PCF8563::error()
{
}