#include "mbed.h"
#include <inttypes.h>
// https://developer.mbed.org/handbook/DigitalOut
// https://developer.mbed.org/handbook/BusOut
class MyLed 
{
private:
    DigitalOut *led1;   // Adresse des eigentlichen Zieles - auf eine Klasse DigitalOut - erzeugen
    BusOut *led_bus;
    MyLed();            // Standardkonstruktor, auf den von außen nicht zugegriffen werden kann
    
public:
// Parametrisierten Konstruktor - selber Name wie Klasse - mit einem Pin Namen als Parameter
    MyLed(PinName ld1)
    {
        // erzeugt ein neues DigitalOut Objekt led1 mit Pin ld1 über Adresse von
        // led1 = &DigitalOut(ld1);
        led1 = new DigitalOut(ld1);
    };
    MyLed(PinName p1, PinName p2, PinName p3, PinName p4, PinName p5, PinName p6, PinName p7, PinName p8)
    {
        led_bus = new BusOut(p1, p2, p3, p4, p5, p6, p7, p8);
        led_bus->write(0x0);        // led_bus initialisieren
    }
    MyLed(PinName ld_bus[])         // Konstruktor mit Pin-Array
    {
        led_bus = new BusOut(ld_bus);
        led_bus->write(0x0);        // led_bus initialisieren
    }
/*
    MyLed(PinName ld_bus[]) : led_bus(&BusOut(ld_bus)) // mit Initialisierungsliste
    {
        led_bus->write(0x0);        // led_bus initialisieren
    }
*/    
    // Methoden oder Memberfunktionen
    void LedOn(uint8_t wert)
    {
        led_bus->write(wert);
    }
    void LedOn()
    {
        // Aufruf der Methode write() in der Klasse DigitalOut --> über den Zeiger led1
        //(*led1).write(1);
        led1->write(1);
    }
    void LedOff()
    {
        //(*led1).write(0);
        led1->write(0);
    }
};

int main() {
    MyLed myLed1(LED1);
    PinName pinarr[16] = {P1_13,P1_12,P1_7,P1_6,P1_4, P1_3, P1_1, P1_0};    // Array mit Pins setzen
// erzeugen einer Variablen myLedBus der Klasse MyLed mit 8 Pins als Parameter
    MyLed myLedBus(P1_13, P1_12, P1_7, P1_6, P1_4, P1_3, P1_1, P1_0);       // ODER ....
// erzeugen einer Variablen myLedBus der Klasse MyLed mit Pin-Array als Parameter
    //MyLed myLedBus(pinarr);    // Problem mit Reset!!!
    uint8_t zaehler = 0;

    while(1) {
        myLedBus.LedOn(zaehler++);      // Hochzählen auf oberen 8 Leds
        myLed1.LedOn(); 
        wait(0.2);
        myLedBus.LedOn(0x0);
        myLed1.LedOff();
        wait(0.2);
    }
}
