// see: [[RTOS: Demonstration Setup]]
// Trace ab 15:00
// -->>>>> Löschen Sie die Kommentare bei den entsprechenden Synchronisationsmöglichkeiten (LedMutex, LedSemaphore, Signal)
// bzw. geben Sie die Kommentare wieder hinein wenn Sie andere testen wollen

#include "mbed.h"

class Rgb
{
private:
    DigitalOut _led;

public:
    Rgb(PinName ld) : _led(ld) {
        _led = 1;
    };  // Constructor with RgbLed = off

    void LedOn() {
        _led = 0;
    }
    void LedOff() {
        _led.write(1);
    }
};

class HasA
{
private:
    DigitalOut _led;

public:
    HasA(PinName ld) : _led(ld) {};  // Constructor

    void LedOn() {
        _led = 1;
    }
    void LedOff() {
        _led.write(0);
    }
};

void Delay_Nonsense(uint32_t * DelayCounter, uint32_t const * TargetCount)
{
    while(*DelayCounter <= *TargetCount) {
        *DelayCounter = *DelayCounter + 1;
    }
    *DelayCounter = 0;
}

//M3: R(p23); G(p24); B(p25);

HasA Led1(LED1);
HasA Led2(LED2);
HasA Led3(LED3);

Rgb LedR(p23);
Rgb LedG(p24);
Rgb LedB(p25);

Mutex LedMutex;
Semaphore LedSemaphore(1);

//void LedR_Blink(void *pvParameters)
void LedR_Blink()   // red
{
    const int xDelay = 500;                  // Leuchtdauer
    uint32_t BlueDelay = 0;                  // zufällige Verzögerung von ...
    const uint32_t TargetCount = 16000;      // ... bis

    for(;;) {
//       for(int i = 0; i < 10; i++) {      // Zufälligkeit
//          wait_ms(xDelay);
//       }

        // Obtain the Mutex - block for 0 ticks if the semaphore is not
        // immediately available.
//       if( xSemaphoreTake( LEDMutex, ( TickType_t ) 10 ) == pdTRUE )
        //LedMutex.lock();
        LedSemaphore.wait();
        //Thread::signal_wait(0x1);
        {
            LedR.LedOn();
            Delay_Nonsense(&BlueDelay, &TargetCount);
            wait_ms(xDelay);
            LedR.LedOff();
            Delay_Nonsense(&BlueDelay, &TargetCount);
            wait_ms(xDelay);
        }
//     xSemaphoreGive(LEDMutex);
        //LedMutex.unlock();
        LedSemaphore.release();
    }
}

void LedG_Blink()   // green
{
    const int xDelay = 250;
    uint32_t BlueDelay = 0;
    const uint32_t TargetCount = 16000;

    for(;;) {
//       for(int i = 0; i < 10; i++) {
//          wait_ms(xDelay);
//       }

        // Obtain the Mutex - block for 0 ticks if the semaphore is not
        // immediately available.
//       if( xSemaphoreTake( LEDMutex, ( TickType_t ) 10 ) == pdTRUE )
        //LedMutex.lock();
        LedSemaphore.wait();
        //Thread::signal_wait(0x1);
        {
            LedG.LedOn();
            Delay_Nonsense(&BlueDelay, &TargetCount);
            wait_ms(xDelay);
            LedG.LedOff();
            Delay_Nonsense(&BlueDelay, &TargetCount);
            wait_ms(xDelay);
//           xSemaphoreGive(LEDMutex);
        }
        //LedMutex.unlock();
        LedSemaphore.release();


    }
}

void LedB_Blink()   // blue
{
    const int xDelay = 100;
    uint32_t BlueDelay = 0;
    const uint32_t TargetCount = 16000;

    for(;;) {
//       for(int i = 0; i < 10; i++) {      // Zufälligkeit
//          wait_ms(xDelay);
//       }

        // Obtain the Mutex - block for 0 ticks if the semaphore is not
        // immediately available.
//       if( xSemaphoreTake( LEDMutex, ( TickType_t ) 10 ) == pdTRUE )
        //LedMutex.lock();                // Led leuchten wird nicht mehr unterbrochen !!!
        LedSemaphore.wait();
        //Thread::signal_wait(0x1);
        {
            LedB.LedOn();
            Delay_Nonsense(&BlueDelay, &TargetCount);
            wait_ms(xDelay+100);
            LedB.LedOff();
            Delay_Nonsense(&BlueDelay, &TargetCount);
            wait_ms(xDelay);
//           xSemaphoreGive(LEDMutex);
        }
        //LedMutex.unlock();
        LedSemaphore.release();
        //thread.signal_set(0x1);

    }
}

Thread thread1(osPriorityNormal, DEFAULT_STACK_SIZE, NULL);
//Thread thread1;
Thread thread2;
Thread thread3;

int main()
{
    thread1.start(LedR_Blink);
    thread2.start(LedG_Blink);
    thread3.start(LedB_Blink);

    /* Signals
        wait(2);
        thread1.signal_set(0x1);
        wait(2);
        thread2.signal_set(0x1);
        wait(2);
        thread3.signal_set(0x1);
    */
    thread1.join();
    thread2.join();
    thread3.join();
    while(1) {
        Led1.LedOn();
        wait(0.5);
        Led1.LedOff();
        wait(0.5);
    }
}
