/*******************************************************************************
 * Changed: PE, v0.71 works with Ethernet and random Client-ID
 * Copyright (c) 2014, 2015 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial API and implementation and/or initial documentation
 *    Ian Craggs - make sure QoS2 processing works, and add device headers
 *******************************************************************************/

/**
 This is a sample program to illustrate the use of the MQTT Client library
 on the mbed platform.  The Client class requires two classes which mediate
 access to system interfaces for networking and timing.  As long as these two
 classes provide the required public programming interfaces, it does not matter
 what facilities they use underneath. In this program, they use the mbed
 system libraries.

*/

// change this to 0 to output messages to serial instead of LCD
#define USE_LCD 0

#if USE_LCD
#include "C12832.h"

// the actual pins are defined in mbed_app.json and can be overridden per target
C12832 lcd(LCD_MOSI, LCD_SCK, LCD_MISO, LCD_A0, LCD_NCS);

#define logMessage lcd.cls();lcd.printf

#else

#define logMessage printf

#endif

#define MQTTCLIENT_QOS2 1

#include "easy-connect.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

Serial pc(USBTX, USBRX);

static const char alphanum[] =
"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

int stringLength = sizeof(alphanum) - 1;
// use for random
#include "MMA7660.h"
 
MMA7660 MMA(p28, p27);

char genRandom()
{
    if (MMA.testConnection())
        logMessage("get seed: Please shake the board for 1s \r\n");
    int x;    
    for (int i=0; i < 5; i++) {
        x=(int) (MMA.z() * MMA.z() * MMA.z()*100)% 65;
        //logMessage("seed: %d\r\n", x);
        wait_ms(200);
    }
    srand (x);
    return alphanum[rand() % stringLength];
}

int main(int argc, char* argv[])
{
    float version = 0.71;
    char* topic = "mbed/sample/Eth1";

    logMessage("MQTT Publish PE: version is %.2f\r\n", version);

    // connect to Ethernet-LAN with DHCP
    NetworkInterface* network = easy_connect(true);
    if (!network) {
        return -1;
    }
    
    // connect to broker over Ethernet-LAN
    MQTTNetwork mqttNetwork(network);
    MQTT::Client<MQTTNetwork, Countdown> client = MQTT::Client<MQTTNetwork, Countdown>(mqttNetwork);

    const char* hostname = "broker.hivemq.com";     // local RPi: 172.16.63.188; broker.hivemq.com: 35.157.21.220
    int port = 1883;
    logMessage("Connecting to %s:%d\r\n", hostname, port);

    int rc = mqttNetwork.connect(hostname, port);
    if (rc != 0)
        logMessage("rc from TCP connect is %d\r\n", rc);

    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    
    // generate a unique random Client-ID
    char str[20] ="mbed-clientID-";
    srand(time(NULL));
    int i;
    for(i = 14; i < 18; ++i) {
        str[i] = genRandom();
    }
    str[i] = 0;
    data.clientID.cstring = str; 
    logMessage("ClientID: %s\r\n", data.clientID.cstring);
    // only if authentication is used (not now):
    // data.username.cstring = "testuser";
    // data.password.cstring = "testpassword";
    if ((rc = client.connect(data)) != 0)
        logMessage("rc from MQTT connect is %d\r\n", rc);

    MQTT::Message message;

    // publish 5 messages
    for(int t=0; t<5; t++) {
        char buf[100];
        sprintf(buf, "28.4.2017/16:30/21"); // published message
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf)+1;
        rc = client.publish(topic, message);
        wait(2);
    }

    // unsubscribe and disconnect from broker
    if ((rc = client.unsubscribe(topic)) != 0)
        logMessage("rc from unsubscribe was %d\r\n", rc);

    if ((rc = client.disconnect()) != 0)
        logMessage("rc from disconnect was %d\r\n", rc);

    mqttNetwork.disconnect();

    logMessage("Version %.2f: finished\r\n", version);

    return 0;
}
