#include "sensor.h"

extern AnalogIn voltage[];
extern DigitalOut ledLoad;
extern ParametersBlock APP_PARAMETERS;

Ticker tickerSamples;
Timeout samplesTimeout;
unsigned char currentChannel;
float sample[DEFAULT_SAMPLES];
int currentSample;
bool finished;
bool timeout;

float getInstVoltage(unsigned char channel){
    currentChannel = channel;
    currentSample = 0;
    finished = false;
    timeout = false;
    tickerSamples.attach_us(&readSample, APP_PARAMETERS.SAMPLES_DELAY_US);
    samplesTimeout.attach_us(&timeoutReadingSamples, (DEFAULT_SAMPLES + 2) * APP_PARAMETERS.SAMPLES_DELAY_US);
    
    while(!finished && !timeout){
        wait(0.1f);
    }
    
    float resp = calculateRMS(APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.floatValue, APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.floatValue);
    float limit = 0;
    if(channel == 0){
        limit = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V;
    } else{
        limit = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V;
    }
    if(resp < limit){
        return 0;
    } else{
        return resp;
    }
}

float getInstCurrent(){
    currentChannel = 2;
    currentSample = 0;
    finished = false;
    timeout = false;
    tickerSamples.attach_us(&readSample, APP_PARAMETERS.SAMPLES_DELAY_US);
    samplesTimeout.attach_us(&timeoutReadingSamples, (DEFAULT_SAMPLES + 2) * APP_PARAMETERS.SAMPLES_DELAY_US);
    
    while(!finished && !timeout){
        wait(0.1f);
    }
    
    float resp = calculateRMS(APP_PARAMETERS.SAMPLES_CURRENT_ANG_COEF.floatValue, APP_PARAMETERS.SAMPLES_CURRENT_LIN_COEF.floatValue);
    float limit = APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.floatValue;
    if(resp < limit){
        return 0;
    } else{
        return resp;
    }
}

bool getSensorState(unsigned char channel){
    unsigned char lineChannel = channel == 1 ? 0 : 1;
    float line = getInstVoltage(lineChannel);
    float load = getInstVoltage(channel);
    
    if((line - load) > (line*APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)/100.0){
        ledLoad = LED_ON;
        return SENSOR_COM_FORNECIMENTO;
    } else if((line - load) < -(line*APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)/100.0){
        ledLoad = LED_ON;
        return SENSOR_SEM_FORNECIMENTO;
    } else{
        ledLoad = LED_OFF;
        return SENSOR_SEM_FORNECIMENTO;
    }
}

bool checkVoltageReturn(unsigned char channel){
    unsigned char lineChannel = channel == 1 ? 0 : 1;
    float line = getInstVoltage(lineChannel);
    float load = getInstVoltage(channel);
    
    if(load > (line + (line*APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)/100.0)){
        return SENSOR_COM_FORNECIMENTO;
    } else{
        return SENSOR_SEM_FORNECIMENTO;
    }
}

void readSample(){
    sample[currentSample++] = voltage[currentChannel];
    if(currentSample == DEFAULT_SAMPLES){
        finished = true;
        samplesTimeout.detach();
        tickerSamples.detach();
    }
}

void timeoutReadingSamples(){
    tickerSamples.detach();
    timeout = true;
}

float calculateRMS(float angCoef, float linCoef){
    float rms = 0;
    for(int i=0; i < DEFAULT_SAMPLES; i++){
        sample[i] = abs(sample[i]*angCoef + linCoef);
        rms += sample[i]*sample[i];
    }
    rms = rms / DEFAULT_SAMPLES;
    return sqrt(rms);
}
