#ifndef MM_H
#define MM_H

#include "mbed.h"
#include "queue.h"
#include "sensor.h"
#include "alarm.h"
#include "appParameters.h"
#include "debug.h"

typedef struct{
    unsigned int time;
    union{
        float floatValue;
        unsigned char bytes[4];
    } value;
} LeituraMM;

extern Alarm alarm;
extern DigitalOut ledLoad;

class MemoriaMassa {

    Ticker leituraPeriodica;
    int mmPeriodoSec;
    bool lerAgora;
    
    PersistentCircularQueue queue[3];
    
  public:
    void iniciaLeituras(int periodoSec, int size, int sector1, int sector2, int sector3);
    void disparaLeitura();
    void executaLeitura();
    char* getMM(int channel);
    void checkAlarms(float ch1, float ch2, float ch3);

};

#endif
