#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "settings.h"
#include "debug.h"
#include "version.h"
#include "FreescaleWatchdog.h"
#include "serialNumber.h"
#include "parameters.h"
#include "appParameters.h"
#include "v2hardware.h"
#include "ggs.h"
#include "sensor.h"
#include "memoriaMassa.h"
#include "alarm.h"
#include "boxAlarm.h"
#include "pima.h"
#include "announce.h"

ParametersBlock APP_PARAMETERS;

unsigned char medidor[MEDIDOR_LENGTH];  // Numero do Medidor com 7 bytes BCD (14 digitos)
                                        // Obs: protocolo Piminha usa 5 bytes BCD (completamos com zeros a esquerda os outros 2 bytes)
                                        // e ELO usa 14 bytes ASCII (transformamos em 7 bytes BCD)
unsigned char totAtiva[ENERGIAS_LENGTH];                // Totalizador de Energia Ativa - 3 bytes BCD = 6 dígitos
unsigned char totReativaIndutiva[ENERGIAS_LENGTH];      // Totalizador de Energia Reativa Indutiva - 3 bytes BCD = 6 dígitos
unsigned char totReativaCapacitiva[ENERGIAS_LENGTH];    // Totalizador de Energia Reativa Capacitiva - 3 bytes BCD = 6 dígitos

void iniciaWd();
void feedWd();
void softReset();
void blinkLeds();
void printSerialNumber();
void printParameters();
void detectaCargaSemCorte();

#endif
