#include "appCommands.h"
#include "LM75B.h"

extern LM75B lineTemperature;
extern LM75B loadTemperature;
extern LM75B cpuTemperature;

void cmdLerTemperatura(){
    char resp[12];
    union{
        float measure;
        char bytes[4];
    } temp1;
    
    union{
        float measure;
        char bytes[4];
    } temp2;
    
    union{
        float measure;
        char bytes[4];
    } temp3;
    
    temp1.measure = lineTemperature;
    temp2.measure = loadTemperature;
    temp3.measure = cpuTemperature;

    memcpy(resp, temp1.bytes, 4);
    memcpy(resp+4, temp2.bytes, 4);
    memcpy(resp+8, temp3.bytes, 4);

    exec.enviaResposta(RESP_TEMPERATURA, resp, 12);
}
