#include "appCommands.h"

#ifndef RAMAL

extern Pima pima;

#define SUCESSO                     0x00
#define FALHA_COMUNICACAO_MEDIDOR   0xff
#define GRANDEZA_NAO_ENCONTRADA     0xfe

void cmdLerEnergiaAtiva(){
    char resp[15] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    resp[13] = pima.getTotActivePower()[2] << 4;
    resp[12] = (pima.getTotActivePower()[1] << 4) | (pima.getTotActivePower()[2] >> 4);
    resp[11] = (pima.getTotActivePower()[0] << 4) | (pima.getTotActivePower()[1] >> 4);
    resp[10] = pima.getTotActivePower()[0] >> 4;
    
    if(pima.getTotActivePower()[0] == 0xff){    // Nao existe uma leitura valida de energia ativa
        if(pima.getMeterNumber()[0] == 0xff){ // Nao existe nenhuma leitura atualizada de medidor
            resp[0] = FALHA_COMUNICACAO_MEDIDOR;
        } else{ // Nao leu energia ativa, mas tem alguma leitura atualizada
            resp[0] = GRANDEZA_NAO_ENCONTRADA;
        }
    } else{
        resp[0] = SUCESSO;
    }
    exec.enviaResposta(RESP_LER_ENERGIA_ATIVA, resp, 15);
}

#endif  // ndef(RAMAL)