#include "appCommands.h"
#include "alarm.h"

#define ALARMES_FALHA     1
#define ALARMES_FIM       2

extern Alarm alarm;
char* respAlarm;

void cmdLerAlarmes(int block){
    if(block == 0){
        free(respAlarm);
        respAlarm = alarm.getAllAlarms();
    }

    if(respAlarm == NULL){
        exec.enviaResposta(RESP_LER_ALARMES, ALARMES_FALHA);
    } else{
        int alarmSize = APP_PARAMETERS.ALARMS_QUEUE_SIZE;
        if(alarmSize < 0 || alarmSize > 127){
            alarmSize = 100;   // Use default
        }
        int blocks = ceil(alarmSize / 25.0);
        if(blocks < 0 || blocks > 6){
            blocks = 4; // Use default of 100 entries
        }
        if(block >= blocks){
            exec.enviaResposta(RESP_LER_ALARMES, ALARMES_FIM);
            free(respAlarm);
        } else{
            int size = 8*25;
            if(block == blocks-1){
                size = 8*(APP_PARAMETERS.ALARMS_QUEUE_SIZE % 25);
                if(size == 0){
                    size = 8*25;
                }
            }
            exec.enviaResposta(RESP_LER_ALARMES, respAlarm+block*8*25, size);
        }
    }
}
