#include "appCommands.h"
#include "sensor.h"

void cmdGrandezaInstantanea(int channel){
    union{
        float measure;
        char bytes[4];
    } resp;
    
    switch(channel){
        case 0: // Tensao de Carga
        {
            int lineChannel = APP_PARAMETERS.LOAD_CHANNEL == 0 ? 1 : 0;
            float line = getInstVoltage(lineChannel);
            resp.measure = line - getInstVoltage(APP_PARAMETERS.LOAD_CHANNEL);
            break;
        }
        case 1: // Tensao de Linha
            resp.measure = getInstVoltage(APP_PARAMETERS.LOAD_CHANNEL == 0 ? 1 : 0);
            break;
        case 2: // Corrente
            resp.measure = getInstCurrent();
            break;
    }

    exec.enviaResposta(RESP_GRANDEZA_INSTANTANEA, resp.bytes, 4);
}
