#ifndef APPPARAMETERS_H
#define APPPARAMETERS_H

#include "mbed.h"
#include "settings.h"
#include "parameters.h"
#include "debug.h"

#define ALARME_LINHA_TENSAO_ZERO        0
#define ALARME_LINHA_TENSAO_MINIMA      1
#define ALARME_LINHA_TENSAO_MAXIMA      2
#define ALARME_CORRENTE_ZERO            3
#define ALARME_CORRENTE_MINIMA          4
#define ALARME_CORRENTE_MAXIMA          5
#define ALARME_CARGA_TENSAO_ZERO        6
#define ALARME_CARGA_TENSAO_MINIMA      7
#define ALARME_CARGA_TENSAO_MAXIMA      8
#define ALARME_CAIXA                    9
#define ALARME_RESERVADO1               10
#define ALARME_RESERVADO2               11
#define ALARME_RETORNO_POTENCIAL        12

typedef struct {
    unsigned int estadoRele;
    unsigned int RELIGAR_LARGURA_PULSO_MS;    // Largura do pulso enviado ao rele em milissegundos para religar
    unsigned int CORTAR_LARGURA_PULSO_MS;     // Largura do pulso enviado ao rele em milissegundos para cortar
    unsigned int DELAY_SENSOR_MS;             // Tempo esperado apos enviar um pulso para o rele e antes de verificar o estado do sensor de fornecimento (em milissegundos)
    unsigned int INTERVALO_SILENCIO_S;        // intervalo sem receber bytes na rede para considerar que a linha esta livre pra envio do anuncio
    unsigned int INTERVALO_WD_NETWORK_S;      // intervalo de watchdog da comunicacao de rede, em segundos. Se nao receber comandos apos este periodo vai resetar
    unsigned int LIMITE_TENSAO_SENSOR_V;      // Limite de tensao em volts RMS no conversor A/D para considerar que a linha esta energizada
    unsigned int SAMPLES;                     // Numero de amostras para calculo da tensao RMS nos sensores de carga e linha
    unsigned int SAMPLES_DELAY_US;            // Intervalo entre amostras para calculo da tensao RMS (em microssegundos)
    union{
        float floatValue;                     // Coeficiente angular das amostras de tensao do A/D
        char bytes[4];
    } SAMPLES_VOLTAGE_ANG_COEF;
    union{
        float floatValue;                     // Coeficiente linear das amostras de tensao do A/D
        char bytes[4];
    } SAMPLES_VOLTAGE_LIN_COEF;
    unsigned int LOAD_CHANNEL;                // Indica o canal (0 ou 1) onde esta ligada a carga, para que as rotinas de corte e religa verifiquem a alimentacao corretamente
    unsigned int INTERVALO_MM_S;              // Intervalo de leitura de Memoria de Massa em segundos
    unsigned int MM_SIZE;                     // Numero maximo de registros da memoria de massa
    unsigned int contadorCiclos;              // Totalizador de numero de operacoes de corte/religa
    unsigned int ENABLE_ALARMS;               // Bitmask para habilitacao dos alarmes
    unsigned int ALARMS_STATES;               // Estados dos alarmes
    unsigned int ALARMS_QUEUE_SIZE;           // Tamanho maximo da fila de alarmes
    unsigned int LIMITE_TENSAO_ZERO_CH0_V;
    unsigned int LIMITE_TENSAO_MINIMA_LINHA_V;
    unsigned int LIMITE_TENSAO_MAXIMA_LINHA_V;
    unsigned int LIMITE_TENSAO_ZERO_CH1_V;
    unsigned int LIMITE_TENSAO_MINIMA_CARGA_V;
    unsigned int LIMITE_TENSAO_MAXIMA_CARGA_V;
    unsigned int PROTOCOLO_MEDIDOR;           // Protocolo de comunicacao com medidor: 0 = PIMA ELO, 1 = Piminha Copel, tambem chamado de SER-311
    unsigned int INTERVALO_WD_METER_S;        // intervalo de watchdog da comunicacao com medidor, em segundos. Se nao receber dados apos este periodo vai resetar
    unsigned int PIMA_TIMEOUT_PACOTE_S;    // Intervalo em segundos para aguardar os 3 pacotes piminha (as 3 energias) logo apos receber o primeiro byte de um pacote. Eh necessario aguardar pois caso contrario, ao interpretar cada pacote que chega separadamente acontece de perder o pacote que vem logo em seguida, entao precisamos juntar todos os pacotes para depois tratar.
    unsigned int PIMA_VALIDADE_MEDIDOR_S;  // Validade em segundos da informacao de numero do medidor. Se ficar este periodo sem receber pacote do medidor considera medidor invalido (ou seja, medidor fica com valor 0xFFFFFFFFFFFFFF no anuncio).
    unsigned int PIMA_VALIDADE_ENERGIA_ATIVA_S;                // Validade em segundos da informacao de energia ativa. Apos este periodo sem receber nova informacao de energia ativa, conisidera a informacao inexistente.
    unsigned int PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S;     // Validade em segundos da informacao de energia reativa indutiva. Apos este periodo sem receber nova informacao de energia reativa indutiva, conisidera a informacao inexistente.
    unsigned int PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S;   // Validade em segundos da informacao de energia reativa capacitiva. Apos este periodo sem receber nova informacao de energia reativa capacitiva, conisidera a informacao inexistente.
    unsigned int PIMA_AUTOBAUD_ENABLE;     // Habilita (1) ou desabilita (0) o autobaud, que eh a tentativa de comunicacao com o medidor em varios baudrates (300, 600, 1200, 1800, 2400 e 4800 bps)
    unsigned int PIMA_AUTOBAUD_TIMEOUT_S;  // Intervalo em segundos para aguardar pacotes do medidor em cada baudrate testado pelo procedimento de autobaud.
    unsigned int RADIO_BAUDRATE_BPS;       // Baudrate da comunicacao com o radio via UART.
    union{
        float floatValue;
        char bytes[4];
    } LIMITE_CORRENTE_ZERO_A;
    union{
        float floatValue;
        char bytes[4];
    } LIMITE_CORRENTE_MINIMA_A;
    union{
        float floatValue;
        char bytes[4];
    } LIMITE_CORRENTE_MAXIMA_A;
    union{
        float floatValue;                     // Coeficiente angular das amostras de corrente do A/D
        char bytes[4];
    } SAMPLES_CURRENT_ANG_COEF;
    union{
        float floatValue;                     // Coeficiente linear das amostras de tensao do A/D
        char bytes[4];
    } SAMPLES_CURRENT_LIN_COEF;
    unsigned int ENABLE_LOAD_PROFILE;           // Habilita gravacao da memoria de massa
    unsigned int DISCOVERY_DELAY_ANG_COEF_MS;
    unsigned int DISCOVERY_DELAY_LIN_COEF_MS;
    unsigned int ANNOUNCE_INTERVAL_S;
    unsigned int DUMMY;
    
} ParametersBlock;

void validateAppParameters();
bool isAlarmEnabled(int alarm);
bool getAlarmState(int alarm);
void setAlarmState(int alarm, bool state);

extern ParametersBlock APP_PARAMETERS;
extern Parameters param;

#endif
