#ifndef APPCOMMANDS_H
#define APPCOMMANDS_H

#include "ggs.h"
#include "parameters.h"
#include "appParameters.h"
#include "serialNumber.h"
#include "settings.h"
#include "pima.h"
#include "announce.h"
#include "debug.h"

#define CMD_LER_ENERGIA_ATIVA               0x01
#define RESP_LER_ENERGIA_ATIVA              0x02
#define CMD_LER_ENERGIA_REATIVA_INDUTIVA    0x03
#define RESP_LER_ENERGIA_REATIVA_INDUTIVA   0x04
#define CMD_LER_ENERGIA_REATIVA_CAPACITIVA  0x05
#define RESP_LER_ENERGIA_REATIVA_CAPACITIVA 0x06
#define CMD_CORTAR                          0x07
#define RESP_CORTAR                         0x08
#define CMD_RELIGAR                         0x09
#define RESP_RELIGAR                        0x0a
#define CMD_ESTADO_FORNECIMENTO             0x0b
#define RESP_ESTADO_FORNECIMENTO            0x0c
#define CMD_BUSCAR_MEDIDOR                  0x0d
#define RESP_BUSCAR_MEDIDOR                 0x0e
#define CMD_BUSCAR_CONCENTRADOR             0x0f
#define RESP_BUSCAR_CONCENTRADOR            0x10
#define CMD_BUSCAR_DENDRION                 0x11
#define RESP_BUSCAR_DENDRION                0x12
#define CMD_LER_VERSAO                      0x13
#define RESP_LER_VERSAO                     0x14
#define CMD_RESET                           0x15
#define RESP_RESET                          0x16
#define CMD_LER_NUM_SERIE                   0x17
#define RESP_LER_NUM_SERIE                  0x18
#define CMD_GRAVAR_NUM_SERIE                0x19
#define RESP_GRAVAR_NUM_SERIE               0x1a
#define CMD_LER_PARAMETROS                  0x1b
#define RESP_LER_PARAMETROS                 0x1c
#define CMD_CONFIGURAR_PARAMETROS           0x1d
#define RESP_CONFIGURAR_PARAMETROS          0x1e
#define CMD_LER_RELOGIO                     0x1f
#define RESP_LER_RELOGIO                    0x20
#define CMD_GRANDEZA_INSTANTANEA            0x21
#define RESP_GRANDEZA_INSTANTANEA           0x22
#define CMD_TEMPERATURA                     0x23
#define RESP_TEMPERATURA                    0x24
#define CMD_MEMORIA_MASSA                   0x25
#define RESP_MEMORIA_MASSA                  0x26
//#define RESERVADO                           0x27
//#define RESERVADO                           0x28
//#define CMD_DETECTA_CARGA                   0x29
//#define RESP_DETECTA_CARGA                  0x2a
#define CMD_LER_CICLOS_CORTE                0x2b
#define RESP_LER_CICLOS_CORTE               0x2c
//#define CMD_LER_PARAM_BLUETOOTH             0x2d
//#define RESP_LER_PARAM_BLUETOOTH            0x2e
//#define CMD_GRAVAR_PARAM_BLUETOOTH          0x2f
//#define RESP_GRAVAR_PARAM_BLUETOOTH         0x30
//#define CMD_EXEC_CMD_BTM                    0x31
//#define RESP_EXEC_CMD_BTM                   0x32
#define CMD_LER_ALARMES                     0x33
#define RESP_LER_ALARMES                    0x34
#define CMD_GRAVAR_RELOGIO                  0x35
#define RESP_GRAVAR_RELOGIO                 0x36

extern CommandExecutor exec;
extern Parameters param;
extern SerialNumber sn;
extern ParametersBlock APP_PARAMETERS;
extern DigitalOut ledNetwork;
extern void softReset();

void enviaRespostaGGS(char * dados, int tamanho);
void executaComando(bool broadcast, unsigned char tamanho, unsigned char sequencia, unsigned char tipo, char * dados);

void cmdLerVersao();
void cmdLerNumeroSerie();
void cmdGravarNumeroSerie(char * dados, unsigned char tamanhoDados);
void cmdReset();
void cmdLerParametros();
void cmdConfigurarParametros(char * dados, unsigned char tamanhoDados);
void cmdLerRelogio();

void cmdCortar();
void cmdReligar();
void cmdEstadoFornecimento();
void cmdLerEnergiaAtiva();
void cmdLerEnergiaReativaIndutiva();
void cmdLerEnergiaReativaCapacitiva();
void cmdBuscarMedidor(char * dados, unsigned char tamanhoDados);
void cmdBuscarDendrion(bool broadcast);
void respBuscarConcentrador(bool broadcast, char * dados, unsigned char tamanhoDados);
//void cmdDetectaCarga();
void cmdLerCiclosCorte();
//void cmdLerParamBluetooth();
//void cmdGravarParamBluetooth(char * dados, unsigned char tamanhoDados);
//void cmdExecCmdBtm(char* dados, unsigned char tamanhoDados);

void cmdGrandezaInstantanea(int channel);
void cmdMemoriaMassa(int channel, int block);
void cmdLerAlarmes(int block);
void cmdLerTemperatura();

void atualizaEstadoRele(unsigned char estado);
unsigned char lerEstadoRele();

void cmdGravarRelogio(char * dados, unsigned char tamanhoDados);

#endif
