#include "appCommands.h"

void enviaRespostaGGS(char * dados, int tamanho){
    for(int i=0; i < tamanho; i++){
        ggsStream.putc(dados[i]);
    }
}

void executaComando(bool broadcast, unsigned char tamanho, unsigned char sequencia, unsigned char tipo, char * dados){
    ledNetwork = LED_ON;
    switch(tipo){
        case CMD_LER_VERSAO:
            cmdLerVersao();
            break;
        case CMD_LER_NUM_SERIE:
            cmdLerNumeroSerie();
            break;
        case CMD_GRAVAR_NUM_SERIE:
            cmdGravarNumeroSerie(dados, tamanho - TAMANHO_MINIMO_PACOTE);
            exec.carregaEndereco(sn.get());
            break;
        case CMD_RESET:
            cmdReset();
            break;
        case CMD_CORTAR:
            cmdCortar();
            break;
        case CMD_RELIGAR:
            cmdReligar();
            break;
        case CMD_ESTADO_FORNECIMENTO:
            cmdEstadoFornecimento();
            break;
#ifndef RAMAL       // só ativa comandos de medidor se o equipamento é um smart breaker
        case CMD_LER_ENERGIA_ATIVA:
            cmdLerEnergiaAtiva();
            break;
        case CMD_LER_ENERGIA_REATIVA_INDUTIVA:
            cmdLerEnergiaReativaIndutiva();
            break;
        case CMD_LER_ENERGIA_REATIVA_CAPACITIVA:
            cmdLerEnergiaReativaCapacitiva();
            break;
        case CMD_BUSCAR_MEDIDOR:
            cmdBuscarMedidor(dados, tamanho - TAMANHO_MINIMO_PACOTE);
            break;
#endif            
        case CMD_BUSCAR_DENDRION:
            cmdBuscarDendrion(broadcast);
            break;
        case RESP_BUSCAR_CONCENTRADOR:
            respBuscarConcentrador(broadcast, dados, tamanho - TAMANHO_MINIMO_PACOTE);
            break;
        case CMD_LER_PARAMETROS:
            cmdLerParametros();
            break;
        case CMD_CONFIGURAR_PARAMETROS:
            cmdConfigurarParametros(dados, tamanho - TAMANHO_MINIMO_PACOTE);
            break;
        case CMD_LER_RELOGIO:
            cmdLerRelogio();
            break;
        case CMD_GRANDEZA_INSTANTANEA:
            cmdGrandezaInstantanea(dados[0]);
            break;
        case CMD_MEMORIA_MASSA:
            cmdMemoriaMassa(dados[0], dados[1]);
            break;
//        case CMD_DETECTA_CARGA:
//            cmdDetectaCarga();
//            break;
        case CMD_LER_CICLOS_CORTE:
            cmdLerCiclosCorte();
            break;
//      case CMD_LER_PARAM_BLUETOOTH:
//            cmdLerParamBluetooth();
//            break;
//      case CMD_GRAVAR_PARAM_BLUETOOTH:
//            cmdGravarParamBluetooth(dados, tamanho - TAMANHO_MINIMO_PACOTE);
//            break;
//      case CMD_EXEC_CMD_BTM:
//            cmdExecCmdBtm(dados, tamanho - TAMANHO_MINIMO_PACOTE);
//            break;
        case CMD_LER_ALARMES:
            cmdLerAlarmes(dados[0]);
            break;
        case CMD_GRAVAR_RELOGIO:
            cmdGravarRelogio(dados, tamanho - TAMANHO_MINIMO_PACOTE);
            break;
        case CMD_TEMPERATURA:
            cmdLerTemperatura();
            break;
    }
}

void atualizaEstadoRele(unsigned char estado){
    APP_PARAMETERS.estadoRele = estado;
    APP_PARAMETERS.contadorCiclos++;
    if(!param.saveParameters()){
        DEBUG(printf("[GGS] Error writing relay state\r\n"));
    }
}

unsigned char lerEstadoRele(){
    return APP_PARAMETERS.estadoRele;
}
