#ifndef ALARM_H
#define ALARM_H

#include "mbed.h"
#include "queue.h"
#include "appParameters.h"
#include "debug.h"

typedef struct{
    unsigned int time;
    unsigned short int code;
    unsigned short int state;
} AlarmEntry;

class Alarm {

    PersistentCircularQueue alarmQueue;
    
  public:
    void loadQueue(int size, int sector);
    void writeAlarm(int code, bool state, bool previousState);
    char* getAllAlarms();

};

#endif
