#include "alarm.h"

void Alarm::loadQueue(int size, int sector){
    alarmQueue.init(size, sector);
    alarmQueue.dropQueue();
    DEBUG(printf("[Alarm] Alarm queue loaded (Max %d records)\r\n", size));
}

void Alarm::writeAlarm(int code, bool state, bool previousState){
    if(state == previousState){
        return;
    }
    AlarmEntry entry;
    entry.time = time(NULL);
    entry.code = code;
    entry.state = state ? 1 : 0;
    
    alarmQueue.add((char*)&entry);
    DEBUG(printf("[Alarm] New record stored: Time=%d, Code=%d, State=%d\r\n", entry.time, entry.code, entry.state));
    setAlarmState(code, state);
}

char* Alarm::getAllAlarms(){
    return alarmQueue.getAll();
}
