#ifndef V2_HARDWARE_H
#define V2_HARDWARE_H

#include "mbed.h"
#include "settings.h"
#include "LM75B.h"

#ifdef TEST_MODE
    DigitalOut ledPowerON(LED1);
    DigitalOut ledNetwork(LED1);
    DigitalOut ledMeter(LED1);
    DigitalOut ledLoad(LED1);
    DigitalOut ledBox(LED2);
    DigitalOut reset_relay(LED3);
    DigitalOut set_relay(LED3);
    DigitalOut isopowerDisable(PTE24);
    DigitalIn boxSensor(D2);
    Serial ggsStream(PTE22, PTE23);
    Serial meter(D14, D15);
    AnalogIn voltage[] = {PTE20, PTE29, PTE20};
    LM75B lineTemperature(PTB3, PTB2, LM75B::ADDRESS_0);
    LM75B loadTemperature(PTB3, PTB2, LM75B::ADDRESS_1);
    LM75B cpuTemperature(PTB3, PTB2, LM75B::ADDRESS_2);
#else
    DigitalOut ledPowerON(PTB0);
    DigitalOut ledNetwork(PTA2);
    DigitalOut ledMeter(PTA4);
    DigitalOut ledLoad(PTE25);
    DigitalOut ledBox(PTA1);
    #ifdef RELES_INVERTIDOS
        DigitalOut reset_relay(PTB16);
        DigitalOut set_relay(PTB17);
    #else
        DigitalOut reset_relay(PTB17);
        DigitalOut set_relay(PTB16);
    #endif
    DigitalOut isopowerDisable(PTE24);
    DigitalIn boxSensor(PTE30);
    Serial ggsStream(PTD3, PTD2);
    Serial meter(NC, PTE21);
    AnalogIn voltage[] = {PTE20, PTE29, PTB1};
    LM75B lineTemperature(PTB3, PTB2, LM75B::ADDRESS_0);
    LM75B loadTemperature(PTB3, PTB2, LM75B::ADDRESS_1);
    LM75B cpuTemperature(PTB3, PTB2, LM75B::ADDRESS_2);
#endif  // TEST_MODE

#endif  // V2_HARDWARE_H
