#include "smartbreaker.h"

#if ( defined( BREAKER ) || defined( RAMAL ) )

//////////////////////////////////////////////////////////////
// Variables

#ifdef CONFIGURE_PINO_STACK
    static volatile bool initOK;
#endif

//////////////////////////////////////////////////////////////
// Function Prototypes

static void initSmartBreaker();


//////////////////////////////////////////////////////////////
// Private Functions

static void initSmartBreaker() {
    #ifdef LED_TESTE
        TestLeds();
    #else
        blinkLeds();
    #endif

    Alarm::init( APP_PARAMETERS.ENABLE_ALARMS, APP_PARAMETERS.ALARMS_STATES );
    Alarm::queue.init( APP_PARAMETERS.ALARMS_QUEUE_SIZE, ALARM_PAGE );
    #ifdef  RESET_ALARMS_ON_BOOT
        Alarm::queue.dropQueue();
    #endif
    Alarm::onUpdate( &updateAlarms );

    #ifdef ED02R3
        sensors.reset();
        sensors.init();
        sensors.setBitValue( ADE7978::VAR_CURRENT, DEFAULT_BIT_INCREMENT_C );
        sensors.setBitValue( ADE7978::VAR_VOLTAGE, DEFAULT_BIT_INCREMENT_V1 );
        sensors.setBitValue( ADE7978::VAR_VOLTAGE2P, DEFAULT_BIT_INCREMENT_V2 );
        for ( int p = 0; p < ADE7978::NUM_PHASES; p++ ) {
            for ( int v = 0; v < ADE7978::NUM_VARS; v++ ) {
                sensors.setGainRegister( static_cast< ADE7978::Phase >( p ), static_cast< ADE7978::Variable >( v ), APP_PARAMETERS.ADE_ANG_COEF[p][v] );
                sensors.setOffsetRegister( static_cast< ADE7978::Phase >( p ), static_cast< ADE7978::Variable >( v ), APP_PARAMETERS.ADE_LIN_COEF[p][v] );
            }
        }

    #else
        rmsChannel[ IDX_RMS_VOLTAGE_CH0 ].setSumParams( APP_PARAMETERS.SAMPLES, APP_PARAMETERS.SAMPLES_DELAY_US );
        rmsChannel[ IDX_RMS_VOLTAGE_CH0 ].setCoeficients( APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.floatValue, APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.floatValue );
        rmsChannel[ IDX_RMS_VOLTAGE_CH0 ].attach( &adChannel[ 0 ], &AnalogIn::read );
        rmsChannel[ IDX_RMS_VOLTAGE_CH1 ].setSumParams( APP_PARAMETERS.SAMPLES, APP_PARAMETERS.SAMPLES_DELAY_US );
        rmsChannel[ IDX_RMS_VOLTAGE_CH1 ].setCoeficients( APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.floatValue, APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.floatValue );
        rmsChannel[ IDX_RMS_VOLTAGE_CH1 ].attach( &adChannel[ 1 ], &AnalogIn::read );
        rmsChannel[ IDX_RMS_CURRENT ].setSumParams( APP_PARAMETERS.SAMPLES, APP_PARAMETERS.SAMPLES_DELAY_US );
        rmsChannel[ IDX_RMS_CURRENT ].setCoeficients( APP_PARAMETERS.SAMPLES_CURRENT_ANG_COEF.floatValue, APP_PARAMETERS.SAMPLES_CURRENT_LIN_COEF.floatValue );
        rmsChannel[ IDX_RMS_CURRENT ].setLimits( APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.floatValue );
        rmsChannel[ IDX_RMS_CURRENT ].attach( &adChannel[ 2 ], &AnalogIn::read );

        if ( APP_PARAMETERS.LOAD_CHANNEL == IDX_RMS_VOLTAGE_CH0 ) {
            powerSensor.attach( &rmsChannel[ IDX_RMS_VOLTAGE_CH1 ], &RMS::sampleData , PowerSensor::LineIrq );
            powerSensor.attach( &rmsChannel[ IDX_RMS_VOLTAGE_CH0 ], &RMS::sampleData , PowerSensor::LoadIrq );
        }
        else {
            powerSensor.attach( &rmsChannel[ IDX_RMS_VOLTAGE_CH0 ], &RMS::sampleData , PowerSensor::LineIrq );
            powerSensor.attach( &rmsChannel[ IDX_RMS_VOLTAGE_CH1 ], &RMS::sampleData , PowerSensor::LoadIrq );
        }
        powerSensor.setThreshold( APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V );
    #endif

    #ifdef BREAKER
        isopowerDisable = 0;    // Habilita regulador (PIMA + Alarme Caixa)
        boxAlarm.init();
        pima.setExpirationTimeout( APP_PARAMETERS.PIMA_VALIDADE_MEDIDOR_S, 
                                   APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_ATIVA_S, 
                                   APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S, 
                                   APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S );
        pima.attachTout( &softReset );
        if( APP_PARAMETERS.PROTOCOLO_MEDIDOR == PROTOCOLO_PIMINHA ) {
            pima.iniciaLeituraPiminha( APP_PARAMETERS.PIMA_AUTOBAUD_ENABLE, 
                                       APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S, 
                                       APP_PARAMETERS.INTERVALO_WD_METER_S, 
                                       APP_PARAMETERS.PIMA_TIMEOUT_PACOTE_S );
        } 
        else
            pima.iniciaLeituraPima( APP_PARAMETERS.PIMA_AUTOBAUD_ENABLE, 
                                    APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S, 
                                    APP_PARAMETERS.INTERVALO_WD_METER_S);
    #endif

/*
    const LimitsMM lmm = {
        .loadChannel = APP_PARAMETERS.LOAD_CHANNEL,
        .limiteTensaoZeroCh0 = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V,
        .limiteTensaoZeroCh1 = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V,
        .limiteTensaoSensorV = APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V,
        .limiteTensaoMinimaLinhaV = APP_PARAMETERS.LIMITE_TENSAO_MINIMA_LINHA_V,
        .limiteTensaoMaximaLinhaV = APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_LINHA_V,
        .limiteTensaoMinimaCargaV = APP_PARAMETERS.LIMITE_TENSAO_MINIMA_CARGA_V,
        .limiteTensaoMaximaCargaV = APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_CARGA_V,
        .limiteCorrenteZeroA = APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.floatValue,
        .limiteCorrenteMinimaA = APP_PARAMETERS.LIMITE_CORRENTE_MINIMA_A.floatValue,
        .limiteCorrenteMaximaA = APP_PARAMETERS.LIMITE_CORRENTE_MAXIMA_A.floatValue
    };
    MemoriaMassa::setLimits( lmm );
    for ( int i = 0; i < NUMBER_OF_MM_AREAS; i++ ) {
        mm[i].setLoadProfile( APP_PARAMETERS.ENABLE_LOAD_PROFILE );
        mm[i].iniciaLeituras( APP_PARAMETERS.INTERVALO_MM_S, 
                              APP_PARAMETERS.MM_SIZE, 
                              MM_FIRST_PAGE + i, 
                              i );
        #ifdef RESET_MM_ON_BOOT
            mm[i].dropQueue();
        #endif
    }
*/
    // initializes serial
    #ifdef USE_PINO
        ggsStream.baud( APP_PARAMETERS.RADIO_BAUDRATE_BPS );
        #ifdef  UART_8N2
            ggsStream.format( 8, Serial::None, 2 );
        #endif
    #else
        ggsStream.baud( APP_PARAMETERS.RADIO_BAUDRATE_BPS );
        #ifdef  UART_8N2
            ggsStream.format( 8, Serial::None, 2 );
        #endif
    #endif

    #ifdef WAIT_TO_ANSWER
        wait_ms( 1000 );
        linkLayer.setDelayToSend( 100 );
    #endif

    #ifdef USE_PINO
        linkLayer.bind( &ggsStream, LinkLayer::Pino );
    #else
        linkLayer.bind( &ggsStream, LinkLayer::Raw );
    #endif
    exec.bind( &linkLayer );
    exec.carregaEndereco( sn );
    exec.attach( &softReset );
    exec.iniciaExecutorComandos( APP_PARAMETERS.INTERVALO_WD_NETWORK_S, 
                                 APP_PARAMETERS.INTERVALO_SILENCIO_S,
                                 &executaComando );

    announce.setDelayCoefs( APP_PARAMETERS.DISCOVERY_DELAY_ANG_COEF_MS, 
                            APP_PARAMETERS.DISCOVERY_DELAY_LIN_COEF_MS );
    announce.setIntervals( APP_PARAMETERS.ANNOUNCE_INTERVAL_S, 
                           APP_PARAMETERS.INTERVALO_SILENCIO_S );
        
    #ifdef USE_PINO
        sn.setDefaultNodeAddress( DEFAULT_NODE_ADDRESS );
        // configures Pino stack
        ggsStream.init( APP_PARAMETERS.SRC_ENDPOINT, 
                        APP_PARAMETERS.DEST_NODE, 
                        APP_PARAMETERS.DEST_ENDPOINT, 
                        APP_PARAMETERS.DYNAMIC_DEST );

        #ifdef CONFIGURE_PINO_STACK
            initOK = false;

            PinoCfgStr pinoCfg = {
                .nodeAddress = sn.getNodeAddress(),
                .networkAddress =  APP_PARAMETERS.NETWORK_ADDRESS,
                .networkChannel  = static_cast< uint8_t >( APP_PARAMETERS.NETWORK_CHANNEL ),
                .nodeRole = static_cast< uint8_t >( APP_PARAMETERS.NODE_ROLE )
            };
            initOK = ggsStream.checkCfg( pinoCfg, DEFAULT_PINO_CFG_ATTEMPTS );

            #ifdef CONFIGURE_ACCESS_CYCLE
                // configures access cycle
                uint16_t newCycle = static_cast< uint16_t >( APP_PARAMETERS.ACCESS_CYCLE );
                ggsStream.checkCycle( newCycle, newCycle, DEFAULT_PINO_CFG_ATTEMPTS );
            #endif

            // waits for the stack to start
            ggsStream.checkStop( DEFAULT_PINO_START_ATTEMPTS, APP_PARAMETERS.APP_CONFIG_DATA );
        #endif
        ggsStream.setRequestAttempts( DEFAULT_PINO_TRIES );
        ggsStream.setRequestTimeout( DEFAULT_PINO_TOUT );
        ggsStream.setPerPoll( DEFAULT_PINO_PER_POLL );
        ggsStream.setIRQPin( &pinoInterrupt );
    #endif

    #ifdef BREAKER
        //Alarmes dos sensores de temperatura ( 
        //      1 - temperatura normal, 
        //      2 - temperatura em excesso )

/*        
        TempAlarm::init( PTB3, PTB2 );
        if ( APP_PARAMETERS.TEMPERATURE_ALARM_CUT ) {
            TempAlarm::attach( &corta, TempAlarm::CutIrq );
            TempAlarm::attach( &religa, TempAlarm::RearmIrq );
        }

        tempAlarm[ IDX_TEMP_ALARM_LINE ].setParams( LM75B::ADDRESS_0, 
                                PTC6, 
                                APP_PARAMETERS.LINE_TEMPERATURE_ALARM.floatValue, 
                                APP_PARAMETERS.LINE_TEMPERATURE_HYST.floatValue,
                                Alarm::ALARME_TEMP_LINE, false );

        tempAlarm[ IDX_TEMP_ALARM_LOAD ].setParams( LM75B::ADDRESS_1, 
                                PTD0, 
                                APP_PARAMETERS.LOAD_TEMPERATURE_ALARM.floatValue,
                                APP_PARAMETERS.LOAD_TEMPERATURE_HYST.floatValue,
                                Alarm::ALARME_TEMP_LOAD, false );

        tempAlarm[ IDX_TEMP_ALARM_CPU ].setParams( LM75B::ADDRESS_2, 
                                PTC7, 
                                APP_PARAMETERS.CPU_TEMPERATURE_ALARM.floatValue, 
                                APP_PARAMETERS.CPU_TEMPERATURE_HYST.floatValue,
                                Alarm::ALARME_TEMP_CPU, false );
*/

    #elif defined( RAMAL )
        announce.startAnnounceTimer();
    #endif

    // Flash
    AT25SF041 extFlash( PTD6, PTD7, PTD5, PTD4 );
}

//////////////////////////////////////////////////////////////
// Public Functions

void resetSmartBreaker() {
    #ifdef WATCHDOG_ENABLED
        wdgFeeder.stopService();
    #else
        // Set the VTOR to the application vector table address.
        __disable_irq();
        SCB->VTOR = 0;
        NVIC_SystemReset();
    #endif
}

void mainSmartBreaker() {
    initSmartBreaker();
    for(;;) {
        #ifdef  USE_PINO
            ggsStream.handleFrames();
            ggsStream.handleStream();
        #endif
        exec.trataPacoteGGS();
/*
        for ( int i = 0; i < NUMBER_OF_MM_AREAS; i++ )
            mm[ i ].executaLeitura();
        for ( int i = 0; i < NUMBER_OF_TEMP_ALARMS; i++ )
            tempAlarm[ i ].check();
        if ( Alarm::check() ) {
            exec.enviaNaoSolicitado( CMD_AVISO_ALARME, false );
            Alarm::clrNewAlarm();    // debug 
        }
*/
        #ifdef BREAKER
            if ( boxAlarm.checkState() )
                ledBox = LED_ON;
            else
                ledBox = LED_OFF;

            pima.trataPacotePiminha();
            if ( pima.hasMeter() )
                ledMeter = LED_ON;
            else
                ledMeter = LED_OFF;
            if ( pima.hasMeterChanged() ){
                pima.clrMeterChanged();
                announce.startAnnounceTimer();
            }
        #endif        
        announce.handleAnnounceSending();
    }
}

#endif  // ( defined( BREAKER ) || defined( RAMAL ) )
