#ifndef SETTINGS_H
#define SETTINGS_H

//#define TEST_MODE 1       // Usado para testar na placa de desenvolvimento
//#define DEBUG_ENABLED 1   // Habilita log na USB UART
#define RAMAL 1           // configura a aplicação para modo ramal (o normal é smart breaker)
//#define RELES_INVERTIDOS    1

#define MEDIDOR_DEFAULT_SN "\0\0\0\0\0\0\0"        // para uso com equipamentos sem medidor

#define LED_ON 1
#define LED_OFF 0

#define WATCHDOG_INTERVAL 0.1  // intervalo de alimentacao do watchdog, em segundos (float)
#define RELE_ON 1
#define RELE_OFF 0
#define ESTADO_RELE_INDEFINIDO  3   // Sem estado anterior
#define ESTADO_RELE_ABERTO      2   // Significa que ultimo comando foi de corte
#define ESTADO_RELE_FECHADO     1   // Significa que ultimo comando foi de religacao
#define SENSOR_COM_FORNECIMENTO true
#define SENSOR_SEM_FORNECIMENTO false
#define PROTOCOLO_PIMA_ELO  0   // Protocolo PIMA ELO
#define PROTOCOLO_PIMINHA   1   // Protocolo Piminha Copel, tambem chamado de SER-311

#define DEFAULT_RELIGAR_LARGURA_PULSO_MS 40
#define DEFAULT_CORTAR_LARGURA_PULSO_MS 40
#define DEFAULT_DELAY_SENSOR_MS 500
#define DEFAULT_INTERVALO_SILENCIO_S 2
#define DEFAULT_INTERVALO_WD_NETWORK_S 0    // 0 desabilita o watchdog de rede
#define DEFAULT_LIMITE_TENSAO_SENSOR_V 20
#define DEFAULT_SAMPLES 500
#define DEFAULT_SAMPLES_DELAY_US 2000
#define DEFAULT_SAMPLES_VOLTAGE_ANG_COEF 2719.85f
#define DEFAULT_SAMPLES_VOLTAGE_LIN_COEF -1357.205f // 2719.85 * (-0.499)
#define DEFAULT_LOAD_CHANNEL 1  // Canal onde esta ligada a carga
#define DEFAULT_INTERVALO_MM_S 900
#define DEFAULT_MM_SIZE 100
#define DEFAULT_CONTADOR_CICLOS 0
#define DEFAULT_ENABLE_ALARMS 16383
#define DEFAULT_ALARMS_STATES 0
#define DEFAULT_ALARMS_QUEUE_SIZE 20
#define DEFAULT_LIMITE_TENSAO_ZERO_CH0_V 10
#define DEFAULT_LIMITE_TENSAO_MINIMA_LINHA_V 80
#define DEFAULT_LIMITE_TENSAO_MAXIMA_LINHA_V 140
#define DEFAULT_LIMITE_TENSAO_ZERO_CH1_V 10
#define DEFAULT_LIMITE_TENSAO_MINIMA_CARGA_V 80
#define DEFAULT_LIMITE_TENSAO_MAXIMA_CARGA_V 140
#define DEFAULT_PROTOCOLO PROTOCOLO_PIMINHA
#define DEFAULT_INTERVALO_WD_METER_S 1800
#define DEFAULT_PIMA_TIMEOUT_PACOTE_S 5
#define DEFAULT_PIMA_VALIDADE_MEDIDOR_S 30
#define DEFAULT_PIMA_VALIDADE_ENERGIA_ATIVA_S 60
#define DEFAULT_PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S 60
#define DEFAULT_PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S 60
#define DEFAULT_PIMA_AUTOBAUD_ENABLE 1
#define DEFAULT_PIMA_AUTOBAUD_TIMEOUT_S 30
#define DEFAULT_RADIO_BAUDRATE_BPS 19200
#define DEFAULT_LIMITE_CORRENTE_ZERO_A 0.1f
#define DEFAULT_LIMITE_CORRENTE_MINIMA_A 1.0f
#define DEFAULT_LIMITE_CORRENTE_MAXIMA_A 100.0f
#define DEFAULT_SAMPLES_CURRENT_ANG_COEF 265.0f
#define DEFAULT_SAMPLES_CURRENT_LIN_COEF -132.394f // 265 * (-0.4996)
#define DEFAULT_ENABLE_LOAD_PROFILE 1
#define DEFAULT_DISCOVERY_DELAY_ANG_COEF_MS 200
#define DEFAULT_DISCOVERY_DELAY_LIN_COEF_MS 0
#define DEFAULT_ANNOUNCE_INTERVAL_S 600

#endif
