#include "memoriaMassa.h"

void MemoriaMassa::iniciaLeituras(int periodoSec, int size, int sector1, int sector2, int sector3){
    mmPeriodoSec = periodoSec;
    if(APP_PARAMETERS.ENABLE_LOAD_PROFILE > 0) {
        queue[0].init(size, sector1);
        queue[1].init(size, sector2);
        queue[2].init(size, sector3);
    }
    leituraPeriodica.attach(this, &MemoriaMassa::disparaLeitura, mmPeriodoSec);
    DEBUG(printf("[LP] Periodic Reading started (%d seconds)\r\n", mmPeriodoSec));
}

void MemoriaMassa::disparaLeitura(){
    lerAgora = true;
}

void MemoriaMassa::executaLeitura(){
    if(!lerAgora){
        return;
    }
    
    float f1 = getInstVoltage(0);
    float f2 = getInstVoltage(1);
    float f3 = getInstCurrent();
    
    if(APP_PARAMETERS.LOAD_CHANNEL == 0){
        f1 = f2 - f1;
    } else{
        f2 = f1 - f2;
    }
    
    if(APP_PARAMETERS.ENABLE_LOAD_PROFILE > 0) {
        LeituraMM leitura;
        leitura.value.floatValue = f1;
        leitura.time = time(NULL);
        queue[0].add((char*)&leitura);

        leitura.value.floatValue = f2;
        queue[1].add((char*)&leitura);

        leitura.value.floatValue = f3;
        queue[2].add((char*)&leitura);

        DEBUG(printf("[LP] Reading time = %s\r\n", ctime(&(leitura.time))));
        DEBUG(printf("[LP] New record stored: Time=%d, Ch0=%f\r\n", leitura.time, f1));
        DEBUG(printf("[LP] New record stored: Time=%d, Ch1=%f\r\n", leitura.time, f2));
        DEBUG(printf("[LP] New record stored: Time=%d, Ch2=%f\r\n", leitura.time, f3));
    }

    checkAlarms(f1, f2, f3);

    lerAgora = false;
}

char* MemoriaMassa::getMM(int channel){
    if(channel < 0 || channel > 2){
        DEBUG(printf("[LP] Invalid channel %d\r\n", channel));
        return NULL;
    }
    return queue[channel].getAll();
}

void MemoriaMassa::checkAlarms(float ch1, float ch2, float ch3){
    bool tensaoZero, tensaoMinima, tensaoMaxima, correnteZero, correnteMinima, correnteMaxima;
    int linha, carga, limiteZeroLinha, limiteZeroCarga;
    if(APP_PARAMETERS.LOAD_CHANNEL == 0){
        linha = (int)ch2;
        carga = (int)ch1;
        limiteZeroLinha = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V;
        limiteZeroCarga = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V;
    } else{
        linha = (int)ch1;
        carga = (int)ch2;
        limiteZeroLinha = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V;
        limiteZeroCarga = APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V;
    }
    
    if((linha - carga) > (linha*APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)/100.0){
        ledLoad = LED_ON;
    } else if((linha - carga) < -(linha*APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)/100.0){
        ledLoad = LED_ON;
    } else{
        ledLoad = LED_OFF;
    }
    
    tensaoZero = linha < limiteZeroLinha;
    tensaoMinima = linha < APP_PARAMETERS.LIMITE_TENSAO_MINIMA_LINHA_V;
    tensaoMaxima = linha > APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_LINHA_V;
    
    DEBUG(printf("[LP] Line Zero Voltage ST = %d\r\n", tensaoZero));
    DEBUG(printf("[LP] Line Undervoltage ST = %d\r\n", tensaoMinima));
    DEBUG(printf("[LP] Line Overvoltage  ST = %d\r\n", tensaoMaxima));
    
    if(isAlarmEnabled(ALARME_LINHA_TENSAO_ZERO)){
        alarm.writeAlarm(ALARME_LINHA_TENSAO_ZERO, tensaoZero, getAlarmState(ALARME_LINHA_TENSAO_ZERO));
    }
    if(isAlarmEnabled(ALARME_LINHA_TENSAO_MINIMA)){
        alarm.writeAlarm(ALARME_LINHA_TENSAO_MINIMA, tensaoMinima, getAlarmState(ALARME_LINHA_TENSAO_MINIMA));
    }
    if(isAlarmEnabled(ALARME_LINHA_TENSAO_MAXIMA)){
        alarm.writeAlarm(ALARME_LINHA_TENSAO_MAXIMA, tensaoMaxima, getAlarmState(ALARME_LINHA_TENSAO_MAXIMA));
    }
    
    tensaoZero = carga < limiteZeroCarga;
    tensaoMinima = carga < APP_PARAMETERS.LIMITE_TENSAO_MINIMA_CARGA_V;
    tensaoMaxima = carga > APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_CARGA_V;
    
    DEBUG(printf("[LP] Load Zero Voltage ST = %d\r\n", tensaoZero));
    DEBUG(printf("[LP] Load Undervoltage ST = %d\r\n", tensaoMinima));
    DEBUG(printf("[LP] Load Overvoltage  ST = %d\r\n", tensaoMaxima));
    
    if(isAlarmEnabled(ALARME_CARGA_TENSAO_ZERO)){
        alarm.writeAlarm(ALARME_CARGA_TENSAO_ZERO, tensaoZero, getAlarmState(ALARME_CARGA_TENSAO_ZERO));
    }
    if(isAlarmEnabled(ALARME_CARGA_TENSAO_MINIMA)){
        alarm.writeAlarm(ALARME_CARGA_TENSAO_MINIMA, tensaoMinima, getAlarmState(ALARME_CARGA_TENSAO_MINIMA));
    }
    if(isAlarmEnabled(ALARME_CARGA_TENSAO_MAXIMA)){
        alarm.writeAlarm(ALARME_CARGA_TENSAO_MAXIMA, tensaoMaxima, getAlarmState(ALARME_CARGA_TENSAO_MAXIMA));
    }
    
    correnteZero = ch3 < APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.floatValue;
    correnteMinima = ch3 < APP_PARAMETERS.LIMITE_CORRENTE_MINIMA_A.floatValue;
    correnteMaxima = ch3 > APP_PARAMETERS.LIMITE_CORRENTE_MAXIMA_A.floatValue;
    
    DEBUG(printf("[LP] Zero Current ST = %d\r\n", correnteZero));
    DEBUG(printf("[LP] Undercurrent ST = %d\r\n", correnteMinima));
    DEBUG(printf("[LP] Overcurrent  ST = %d\r\n", correnteMaxima));
    
    if(isAlarmEnabled(ALARME_CORRENTE_ZERO)){
        alarm.writeAlarm(ALARME_CORRENTE_ZERO, correnteZero, getAlarmState(ALARME_CORRENTE_ZERO));
    }
    if(isAlarmEnabled(ALARME_CORRENTE_MINIMA)){
        alarm.writeAlarm(ALARME_CORRENTE_MINIMA, correnteMinima, getAlarmState(ALARME_CORRENTE_MINIMA));
    }
    if(isAlarmEnabled(ALARME_CORRENTE_MAXIMA)){
        alarm.writeAlarm(ALARME_CORRENTE_MAXIMA, correnteMaxima, getAlarmState(ALARME_CORRENTE_MAXIMA));
    }

}
