#include "main.h"

static Watchdog wd;
static Ticker tickerWd;
SerialNumber sn;
Parameters param ((char *)&APP_PARAMETERS, sizeof(APP_PARAMETERS));
CommandExecutor exec;
MemoriaMassa mm;
Alarm alarm;
#ifndef RAMAL        // objetos só existem se o equipamento é um smart breaker
BoxAlarm boxAlarm;
Pima pima;
#endif
Announce announce;

int main()
{
    iniciaWd();
    blinkLeds();
    
    DEBUG(printf("##### %s #####\r\n", version));
    DEBUG(printSerialNumber());

    param.loadParameters();
    DEBUG(printParameters());
    
    isopowerDisable = 0;    // Habilita regulador (PIMA + Alarme Caixa)
    
#ifndef RAMAL
    boxAlarm.init();
#endif    
    alarm.loadQueue(APP_PARAMETERS.ALARMS_QUEUE_SIZE, 3);
    mm.iniciaLeituras(APP_PARAMETERS.INTERVALO_MM_S, APP_PARAMETERS.MM_SIZE, 4, 5, 6);
    
#ifndef RAMAL
    pima.setExpirationTimeout(APP_PARAMETERS.PIMA_VALIDADE_MEDIDOR_S, APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_ATIVA_S, APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S, APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S);
    if(APP_PARAMETERS.PROTOCOLO_MEDIDOR == PROTOCOLO_PIMINHA){
        pima.iniciaLeituraPiminha(APP_PARAMETERS.PIMA_AUTOBAUD_ENABLE, APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S, APP_PARAMETERS.INTERVALO_WD_METER_S, APP_PARAMETERS.PIMA_TIMEOUT_PACOTE_S);
    } else{
        pima.iniciaLeituraPima(APP_PARAMETERS.PIMA_AUTOBAUD_ENABLE, APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S, APP_PARAMETERS.INTERVALO_WD_METER_S);
    }
#endif    
    
    ggsStream.baud(APP_PARAMETERS.RADIO_BAUDRATE_BPS);
    exec.carregaEndereco(sn.get());
    exec.iniciaExecutorComandos(APP_PARAMETERS.INTERVALO_WD_NETWORK_S, APP_PARAMETERS.INTERVALO_SILENCIO_S);
    announce.setDelayCoefs(APP_PARAMETERS.DISCOVERY_DELAY_ANG_COEF_MS, APP_PARAMETERS.DISCOVERY_DELAY_LIN_COEF_MS);
    announce.setIntervals(APP_PARAMETERS.ANNOUNCE_INTERVAL_S, APP_PARAMETERS.INTERVALO_SILENCIO_S);
    
#ifdef RAMAL
    announce.startAnnounceTimer();
#endif

    while(1){
        exec.trataPacoteGGS();
#ifndef RAMAL
        pima.trataPacotePiminha();
        if(pima.hasMeterChanged()){
            announce.startAnnounceTimer();
        }
#endif        
        mm.executaLeitura();
#ifndef RAMAL
        boxAlarm.checkState();
#endif        
        announce.handleAnnounceSending();
    }
    
}

void iniciaWd(){
    wd.Configure();
    tickerWd.attach(&feedWd, WATCHDOG_INTERVAL);
}

void feedWd(){
    wd.Service();
}

void softReset(){
    DEBUG(printf("[main] SoftReset\r\n"));
    tickerWd.detach();
}

void blinkLeds(){
    ledPowerON = LED_ON;
    ledNetwork = LED_OFF;
    ledMeter = LED_OFF;
    ledLoad = LED_OFF;
    ledBox = LED_OFF;
    
    wait_ms(200);
    ledNetwork = LED_ON;
    wait_ms(200);
    ledNetwork = LED_OFF;
    ledMeter = LED_ON;
    wait_ms(200);
    ledMeter = LED_OFF;
    ledLoad = LED_ON;
    wait_ms(200);
    ledLoad = LED_OFF;
    ledBox = LED_ON;
    wait_ms(200);
    ledBox = LED_OFF;
}

void printSerialNumber(){
    printf("[main] SN: ");
    for(int i=0; i < SERIAL_LENGTH; i++){
        printf("%c", sn.get()[i]);
    }
    printf("\r\n");
}

void printParameters(){
    printf("[main] Parameters:");
    for(int i=0; i < sizeof(APP_PARAMETERS); i++){
        printf(" %02x", ((char *)&APP_PARAMETERS)[i]);
    }
    printf("\r\n");
}
