#include "appCommands.h"
#include "sensor.h"
#include "alarm.h"

#define RELIGAR_SUCESSO                     0
#define RELIGAR_NAO_CONFIRMADO              1
#define RELIGAR_POSSIVEL_RETORNO_POTENCIAL  2
#define RELIGAR_RETORNO_POTENCIAL           3
#define RELIGAR_JA_LIGADO                   4
#define RELIGAR_ESTADO_RELE_INCONSISTENTE   5
#define RELIGAR_NAO_CONFIRMADO_JA_FECHADO   6
#define RELIGAR_ESTADO_ILEGAL               7

extern DigitalOut set_relay;
extern Alarm alarm;

void enviaPulso(){
    set_relay = RELE_ON;
    wait_ms(APP_PARAMETERS.RELIGAR_LARGURA_PULSO_MS);
    set_relay = RELE_OFF;
    atualizaEstadoRele(ESTADO_RELE_FECHADO);
    wait_ms(APP_PARAMETERS.DELAY_SENSOR_MS);
}

void cmdReligar(){
#ifdef TEST_MODE
    enviaPulso();
    if(getSensorState(APP_PARAMETERS.LOAD_CHANNEL) == SENSOR_COM_FORNECIMENTO){
        exec.enviaResposta(RESP_RELIGAR, RELIGAR_SUCESSO);
    } else{
        exec.enviaResposta(RESP_RELIGAR, RELIGAR_NAO_CONFIRMADO);
    }
#else
    unsigned char rele = lerEstadoRele();
    char resp = RELIGAR_ESTADO_ILEGAL;
    switch(rele){
        case ESTADO_RELE_INDEFINIDO:
            if(checkVoltageReturn(APP_PARAMETERS.LOAD_CHANNEL) == SENSOR_COM_FORNECIMENTO){
                resp = RELIGAR_POSSIVEL_RETORNO_POTENCIAL;
            } else{
                enviaPulso();
                if(getSensorState(APP_PARAMETERS.LOAD_CHANNEL) == SENSOR_COM_FORNECIMENTO){
                    resp = RELIGAR_SUCESSO;
                } else{
                    resp = RELIGAR_NAO_CONFIRMADO;
                }
            }
            break;
            
        case ESTADO_RELE_ABERTO:
            if(checkVoltageReturn(APP_PARAMETERS.LOAD_CHANNEL) == SENSOR_COM_FORNECIMENTO){
                resp = RELIGAR_RETORNO_POTENCIAL;
                alarm.writeAlarm(ALARME_RETORNO_POTENCIAL, true, false);
            } else{
                enviaPulso();
                if(getSensorState(APP_PARAMETERS.LOAD_CHANNEL) == SENSOR_COM_FORNECIMENTO){
                    resp = RELIGAR_SUCESSO;
                } else{
                    resp = RELIGAR_NAO_CONFIRMADO;
                }
            }
            break;
            
        case ESTADO_RELE_FECHADO:
            if(getSensorState(APP_PARAMETERS.LOAD_CHANNEL) == SENSOR_COM_FORNECIMENTO){
                resp = RELIGAR_JA_LIGADO;
            } else{
                enviaPulso();
                if(getSensorState(APP_PARAMETERS.LOAD_CHANNEL) == SENSOR_COM_FORNECIMENTO){
                    resp = RELIGAR_ESTADO_RELE_INCONSISTENTE;
                } else{
                    resp = RELIGAR_NAO_CONFIRMADO_JA_FECHADO;
                }
            }
            break;
    }
    exec.enviaResposta(RESP_RELIGAR, resp);
#endif
}
