#include "appCommands.h"
#include "sensor.h"
#include "memoriaMassa.h"

#define MM_FALHA     1
#define MM_FIM       2

extern MemoriaMassa mm;
char* respMM[3];

void cmdMemoriaMassa(int channel, int block){
    int ch;
    switch(channel){
        case 0: // Tensao de Carga
            ch = APP_PARAMETERS.LOAD_CHANNEL;
            break;
        case 1: // Tensao de Linha
            ch = APP_PARAMETERS.LOAD_CHANNEL == 0 ? 1 : 0;
            break;
        case 2: // Corrente
            ch = 2;
            break;
    }

    if(block == 0){
        free(respMM[ch]);
        respMM[ch] = mm.getMM(ch);
    }

    if(respMM[ch] == NULL){
        exec.enviaResposta(RESP_MEMORIA_MASSA, MM_FALHA);
    } else{
        int mmSize = APP_PARAMETERS.MM_SIZE;
        if(mmSize < 0 || mmSize > 127){
            mmSize = 100;   // Use default
        }
        int blocks = ceil(mmSize / 25.0);
        if(blocks < 0 || blocks > 6){
            blocks = 4; // Use default of 100 entries
        }
        if(block >= blocks){
            exec.enviaResposta(RESP_MEMORIA_MASSA, MM_FIM);
            free(respMM[ch]);
        } else{
            int size = 8*25;
            if(block == blocks-1){
                size = 8*(APP_PARAMETERS.MM_SIZE % 25);
                if(size == 0){
                    size = 8*25;
                }
            }
            exec.enviaResposta(RESP_MEMORIA_MASSA, respMM[ch]+block*8*25, size);
        }
    }
}
