#include "appCommands.h"

#ifndef RAMAL

extern Pima pima;

#define SUCESSO                     0x00
#define FALHA_COMUNICACAO_MEDIDOR   0xff
#define GRANDEZA_NAO_ENCONTRADA     0xfe

void cmdLerEnergiaReativaCapacitiva(){
    char resp[15] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    resp[13] = pima.getTotCapacitivePower()[2] << 4;
    resp[12] = (pima.getTotCapacitivePower()[1] << 4) | (pima.getTotCapacitivePower()[2] >> 4);
    resp[11] = (pima.getTotCapacitivePower()[0] << 4) | (pima.getTotCapacitivePower()[1] >> 4);
    resp[10] = pima.getTotCapacitivePower()[0] >> 4;
    
    if(pima.getTotCapacitivePower()[0] == 0xff){    // Nao existe uma leitura valida de energia reativa capacitiva
        if(pima.getMeterNumber()[0] == 0xff){ // Nao existe nenhuma leitura atualizada de medidor
            resp[0] = FALHA_COMUNICACAO_MEDIDOR;
        } else{ // Nao leu energia reativa capacitiva, mas tem alguma leitura atualizada
            resp[0] = GRANDEZA_NAO_ENCONTRADA;
        }
    } else{
        resp[0] = SUCESSO;
    }
    exec.enviaResposta(RESP_LER_ENERGIA_REATIVA_CAPACITIVA, resp, 15);
}

#endif  // ndef(RAMAL)