#include "appCommands.h"
#include "serialNumber.h"

#define BOUNDARY_ERROR      -99    //Commands may not span several sectors
#define ALIGN_ERROR         -98    //Data must be aligned on longword (two LSBs zero)
#define PROTECTION_ERROR    -97    //Flash sector is protected
#define ACCESS_ERROR        -96    //Something went wrong
#define COLLISION_ERROR     -95    //During writing something tried to flash which was written to
#define LENGTH_ERROR        -94    //The length must be multiples of 4
#define RUNTIME_ERROR       -93
#define ERASE_ERROR         -92    //The flash was not erased before writing to it
#define PAYLOAD_INVALIDO    -1     //Payload nao possui 25 bytes
#define SUCESSO             0

void cmdGravarNumeroSerie(char * dados, unsigned char tamanhoDados){
    
    if(tamanhoDados != SERIAL_LENGTH){
        exec.enviaResposta(RESP_GRAVAR_NUM_SERIE, (char)PAYLOAD_INVALIDO);
        return;
    }
    
    int resp = sn.set(dados);
    exec.enviaResposta(RESP_GRAVAR_NUM_SERIE, resp);
}
