#include "appCommands.h"

#define SUCESSO             0
#define TAMANHO_INVALIDO    0xff
#define ERRO_GRAVACAO       0xfe

void cmdConfigurarParametros(char * dados, unsigned char tamanhoDados){
    
    if(tamanhoDados != sizeof(APP_PARAMETERS)){
        exec.enviaResposta(RESP_CONFIGURAR_PARAMETROS, (char)TAMANHO_INVALIDO);
        return;
    }
    
    // Totalizador de ciclos de corte/religa nao deve ser alterado
    unsigned int totalizador = APP_PARAMETERS.contadorCiclos;
    memcpy((char *)&APP_PARAMETERS, dados, sizeof(APP_PARAMETERS));
    APP_PARAMETERS.contadorCiclos = totalizador;
    
    if(!param.saveParameters()){
        DEBUG(printf("[GGS] Error writing parameters\r\n"));
        exec.enviaResposta(RESP_CONFIGURAR_PARAMETROS, (char)ERRO_GRAVACAO);
        return;
    }
    exec.enviaResposta(RESP_CONFIGURAR_PARAMETROS, SUCESSO);
    softReset();
}
