#include "appParameters.h"

void validateAppParameters(){
    if(APP_PARAMETERS.estadoRele != ESTADO_RELE_ABERTO && APP_PARAMETERS.estadoRele != ESTADO_RELE_FECHADO){
        APP_PARAMETERS.estadoRele = ESTADO_RELE_INDEFINIDO;
    }
    
    if(APP_PARAMETERS.PROTOCOLO_MEDIDOR != PROTOCOLO_PIMINHA && APP_PARAMETERS.PROTOCOLO_MEDIDOR != PROTOCOLO_PIMA_ELO){
        APP_PARAMETERS.PROTOCOLO_MEDIDOR = DEFAULT_PROTOCOLO;
    }
    
    if(((char *)&APP_PARAMETERS.RELIGAR_LARGURA_PULSO_MS)[0] == 0xff && ((char *)&APP_PARAMETERS.RELIGAR_LARGURA_PULSO_MS)[1] == 0xff && ((char *)&APP_PARAMETERS.RELIGAR_LARGURA_PULSO_MS)[2] == 0xff && ((char *)&APP_PARAMETERS.RELIGAR_LARGURA_PULSO_MS)[3] == 0xff){
        APP_PARAMETERS.RELIGAR_LARGURA_PULSO_MS = DEFAULT_RELIGAR_LARGURA_PULSO_MS;
    }
    
    if(((char *)&APP_PARAMETERS.CORTAR_LARGURA_PULSO_MS)[0] == 0xff && ((char *)&APP_PARAMETERS.CORTAR_LARGURA_PULSO_MS)[1] == 0xff && ((char *)&APP_PARAMETERS.CORTAR_LARGURA_PULSO_MS)[2] == 0xff && ((char *)&APP_PARAMETERS.CORTAR_LARGURA_PULSO_MS)[3] == 0xff){
        APP_PARAMETERS.CORTAR_LARGURA_PULSO_MS = DEFAULT_CORTAR_LARGURA_PULSO_MS;
    }
    
    if(((char *)&APP_PARAMETERS.DELAY_SENSOR_MS)[0] == 0xff && ((char *)&APP_PARAMETERS.DELAY_SENSOR_MS)[1] == 0xff && ((char *)&APP_PARAMETERS.DELAY_SENSOR_MS)[2] == 0xff && ((char *)&APP_PARAMETERS.DELAY_SENSOR_MS)[3] == 0xff){
        APP_PARAMETERS.DELAY_SENSOR_MS = DEFAULT_DELAY_SENSOR_MS;
    }
    
    if(((char *)&APP_PARAMETERS.INTERVALO_SILENCIO_S)[0] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_SILENCIO_S)[1] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_SILENCIO_S)[2] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_SILENCIO_S)[3] == 0xff){
        APP_PARAMETERS.INTERVALO_SILENCIO_S = DEFAULT_INTERVALO_SILENCIO_S;
    }
    
    if(((char *)&APP_PARAMETERS.INTERVALO_WD_NETWORK_S)[0] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_WD_NETWORK_S)[1] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_WD_NETWORK_S)[2] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_WD_NETWORK_S)[3] == 0xff){
        APP_PARAMETERS.INTERVALO_WD_NETWORK_S = DEFAULT_INTERVALO_WD_NETWORK_S;
    }
    
    if(((char *)&APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)[0] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)[1] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)[2] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V)[3] == 0xff){
        APP_PARAMETERS.LIMITE_TENSAO_SENSOR_V = DEFAULT_LIMITE_TENSAO_SENSOR_V;
    }
    
    if(((char *)&APP_PARAMETERS.SAMPLES)[0] == 0xff && ((char *)&APP_PARAMETERS.SAMPLES)[1] == 0xff && ((char *)&APP_PARAMETERS.SAMPLES)[2] == 0xff && ((char *)&APP_PARAMETERS.SAMPLES)[3] == 0xff){
        APP_PARAMETERS.SAMPLES = DEFAULT_SAMPLES;
    }
    
    if(((char *)&APP_PARAMETERS.SAMPLES_DELAY_US)[0] == 0xff && ((char *)&APP_PARAMETERS.SAMPLES_DELAY_US)[1] == 0xff && ((char *)&APP_PARAMETERS.SAMPLES_DELAY_US)[2] == 0xff && ((char *)&APP_PARAMETERS.SAMPLES_DELAY_US)[3] == 0xff){
        APP_PARAMETERS.SAMPLES_DELAY_US = DEFAULT_SAMPLES_DELAY_US;
    }
    
    if(APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.bytes[0] == 0xff && APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.bytes[1] == 0xff && APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.bytes[2] == 0xff && APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.bytes[3] == 0xff){
        APP_PARAMETERS.SAMPLES_VOLTAGE_ANG_COEF.floatValue = DEFAULT_SAMPLES_VOLTAGE_ANG_COEF;
    }
    
    if(APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.bytes[0] == 0xff && APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.bytes[1] == 0xff && APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.bytes[2] == 0xff && APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.bytes[3] == 0xff){
        APP_PARAMETERS.SAMPLES_VOLTAGE_LIN_COEF.floatValue = DEFAULT_SAMPLES_VOLTAGE_LIN_COEF;
    }
    
    if(APP_PARAMETERS.LOAD_CHANNEL != 0 && APP_PARAMETERS.LOAD_CHANNEL != 1){
        APP_PARAMETERS.LOAD_CHANNEL = DEFAULT_LOAD_CHANNEL;
    }
    
    if(((char *)&APP_PARAMETERS.INTERVALO_MM_S)[0] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_MM_S)[1] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_MM_S)[2] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_MM_S)[3] == 0xff){
        APP_PARAMETERS.INTERVALO_MM_S = DEFAULT_INTERVALO_MM_S;
    }
    
    if(((char *)&APP_PARAMETERS.MM_SIZE)[0] == 0xff && ((char *)&APP_PARAMETERS.MM_SIZE)[1] == 0xff && ((char *)&APP_PARAMETERS.MM_SIZE)[2] == 0xff && ((char *)&APP_PARAMETERS.MM_SIZE)[3] == 0xff){
        APP_PARAMETERS.MM_SIZE = DEFAULT_MM_SIZE;
    }
    
    if(((char *)&APP_PARAMETERS.contadorCiclos)[0] == 0xff && ((char *)&APP_PARAMETERS.contadorCiclos)[1] == 0xff && ((char *)&APP_PARAMETERS.contadorCiclos)[2] == 0xff && ((char *)&APP_PARAMETERS.contadorCiclos)[3] == 0xff){
        APP_PARAMETERS.contadorCiclos = DEFAULT_CONTADOR_CICLOS;
    }
    
    if(((char *)&APP_PARAMETERS.ENABLE_ALARMS)[0] == 0xff && ((char *)&APP_PARAMETERS.ENABLE_ALARMS)[1] == 0xff && ((char *)&APP_PARAMETERS.ENABLE_ALARMS)[2] == 0xff && ((char *)&APP_PARAMETERS.ENABLE_ALARMS)[3] == 0xff){
        APP_PARAMETERS.ENABLE_ALARMS = DEFAULT_ENABLE_ALARMS;
    }
    
    if(((char *)&APP_PARAMETERS.ALARMS_STATES)[0] == 0xff && ((char *)&APP_PARAMETERS.ALARMS_STATES)[1] == 0xff && ((char *)&APP_PARAMETERS.ALARMS_STATES)[2] == 0xff && ((char *)&APP_PARAMETERS.ALARMS_STATES)[3] == 0xff){
        APP_PARAMETERS.ALARMS_STATES = DEFAULT_ALARMS_STATES;
    }
    
    if(((char *)&APP_PARAMETERS.ALARMS_QUEUE_SIZE)[0] == 0xff && ((char *)&APP_PARAMETERS.ALARMS_QUEUE_SIZE)[1] == 0xff && ((char *)&APP_PARAMETERS.ALARMS_QUEUE_SIZE)[2] == 0xff && ((char *)&APP_PARAMETERS.ALARMS_QUEUE_SIZE)[3] == 0xff){
        APP_PARAMETERS.ALARMS_QUEUE_SIZE = DEFAULT_ALARMS_QUEUE_SIZE;
    }
    
    if(((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V)[0] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V)[1] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V)[2] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V)[3] == 0xff){
        APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH0_V = DEFAULT_LIMITE_TENSAO_ZERO_CH0_V;
    }
    
    if(((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_LINHA_V)[0] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_LINHA_V)[1] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_LINHA_V)[2] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_LINHA_V)[3] == 0xff){
        APP_PARAMETERS.LIMITE_TENSAO_MINIMA_LINHA_V = DEFAULT_LIMITE_TENSAO_MINIMA_LINHA_V;
    }
    
    if(((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_LINHA_V)[0] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_LINHA_V)[1] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_LINHA_V)[2] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_LINHA_V)[3] == 0xff){
        APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_LINHA_V = DEFAULT_LIMITE_TENSAO_MAXIMA_LINHA_V;
    }
    
    if(((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V)[0] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V)[1] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V)[2] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V)[3] == 0xff){
        APP_PARAMETERS.LIMITE_TENSAO_ZERO_CH1_V = DEFAULT_LIMITE_TENSAO_ZERO_CH1_V;
    }
    
    if(((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_CARGA_V)[0] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_CARGA_V)[1] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_CARGA_V)[2] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MINIMA_CARGA_V)[3] == 0xff){
        APP_PARAMETERS.LIMITE_TENSAO_MINIMA_CARGA_V = DEFAULT_LIMITE_TENSAO_MINIMA_CARGA_V;
    }
    
    if(((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_CARGA_V)[0] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_CARGA_V)[1] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_CARGA_V)[2] == 0xff && ((char *)&APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_CARGA_V)[3] == 0xff){
        APP_PARAMETERS.LIMITE_TENSAO_MAXIMA_CARGA_V = DEFAULT_LIMITE_TENSAO_MAXIMA_CARGA_V;
    }
    
    
    if(((char *)&APP_PARAMETERS.INTERVALO_WD_METER_S)[0] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_WD_METER_S)[1] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_WD_METER_S)[2] == 0xff && ((char *)&APP_PARAMETERS.INTERVALO_WD_METER_S)[3] == 0xff){
        APP_PARAMETERS.INTERVALO_WD_METER_S = DEFAULT_INTERVALO_WD_METER_S;
    }
    
    if(((char *)&APP_PARAMETERS.PIMA_TIMEOUT_PACOTE_S)[0] == 0xff && ((char *)&APP_PARAMETERS.PIMA_TIMEOUT_PACOTE_S)[1] == 0xff && ((char *)&APP_PARAMETERS.PIMA_TIMEOUT_PACOTE_S)[2] == 0xff && ((char *)&APP_PARAMETERS.PIMA_TIMEOUT_PACOTE_S)[3] == 0xff){
        APP_PARAMETERS.PIMA_TIMEOUT_PACOTE_S = DEFAULT_PIMA_TIMEOUT_PACOTE_S;
    }
    
    if(((char *)&APP_PARAMETERS.PIMA_VALIDADE_MEDIDOR_S)[0] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_MEDIDOR_S)[1] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_MEDIDOR_S)[2] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_MEDIDOR_S)[3] == 0xff){
        APP_PARAMETERS.PIMA_VALIDADE_MEDIDOR_S = DEFAULT_PIMA_VALIDADE_MEDIDOR_S;
    }
    
    if(((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_ATIVA_S)[0] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_ATIVA_S)[1] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_ATIVA_S)[2] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_ATIVA_S)[3] == 0xff){
        APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_ATIVA_S = DEFAULT_PIMA_VALIDADE_ENERGIA_ATIVA_S;
    }

    if(((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S)[0] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S)[1] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S)[2] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S)[3] == 0xff){
        APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S = DEFAULT_PIMA_VALIDADE_ENERGIA_REATIVA_INDUTIVA_S;
    }
    
    if(((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S)[0] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S)[1] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S)[2] == 0xff && ((char *)&APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S)[3] == 0xff){
        APP_PARAMETERS.PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S = DEFAULT_PIMA_VALIDADE_ENERGIA_REATIVA_CAPACITIVA_S;
    }
    
    if(APP_PARAMETERS.PIMA_AUTOBAUD_ENABLE != 0 && APP_PARAMETERS.PIMA_AUTOBAUD_ENABLE != 1){
        APP_PARAMETERS.PIMA_AUTOBAUD_ENABLE = DEFAULT_PIMA_AUTOBAUD_ENABLE;
    }
    
    if(((char *)&APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S)[0] == 0xff && ((char *)&APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S)[1] == 0xff && ((char *)&APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S)[2] == 0xff && ((char *)&APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S)[3] == 0xff){
        APP_PARAMETERS.PIMA_AUTOBAUD_TIMEOUT_S = DEFAULT_PIMA_AUTOBAUD_TIMEOUT_S;
    }
    
    if(((char *)&APP_PARAMETERS.RADIO_BAUDRATE_BPS)[0] == 0xff && ((char *)&APP_PARAMETERS.RADIO_BAUDRATE_BPS)[1] == 0xff && ((char *)&APP_PARAMETERS.RADIO_BAUDRATE_BPS)[2] == 0xff && ((char *)&APP_PARAMETERS.RADIO_BAUDRATE_BPS)[3] == 0xff){
        APP_PARAMETERS.RADIO_BAUDRATE_BPS = DEFAULT_RADIO_BAUDRATE_BPS;
    }
    
    if(APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.bytes[0] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.bytes[1] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.bytes[2] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.bytes[3] == 0xff){
        APP_PARAMETERS.LIMITE_CORRENTE_ZERO_A.floatValue = DEFAULT_LIMITE_CORRENTE_ZERO_A;
    }
    
    if(APP_PARAMETERS.LIMITE_CORRENTE_MINIMA_A.bytes[0] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_MINIMA_A.bytes[1] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_MINIMA_A.bytes[2] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_MINIMA_A.bytes[3] == 0xff){
        APP_PARAMETERS.LIMITE_CORRENTE_MINIMA_A.floatValue = DEFAULT_LIMITE_CORRENTE_MINIMA_A;
    }
    
    if(APP_PARAMETERS.LIMITE_CORRENTE_MAXIMA_A.bytes[0] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_MAXIMA_A.bytes[1] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_MAXIMA_A.bytes[2] == 0xff && APP_PARAMETERS.LIMITE_CORRENTE_MAXIMA_A.bytes[3] == 0xff){
        APP_PARAMETERS.LIMITE_CORRENTE_MAXIMA_A.floatValue = DEFAULT_LIMITE_CORRENTE_MAXIMA_A;
    }

    if(APP_PARAMETERS.SAMPLES_CURRENT_ANG_COEF.bytes[0] == 0xff && APP_PARAMETERS.SAMPLES_CURRENT_ANG_COEF.bytes[1] == 0xff && APP_PARAMETERS.SAMPLES_CURRENT_ANG_COEF.bytes[2] == 0xff && APP_PARAMETERS.SAMPLES_CURRENT_ANG_COEF.bytes[3] == 0xff){
        APP_PARAMETERS.SAMPLES_CURRENT_ANG_COEF.floatValue = DEFAULT_SAMPLES_CURRENT_ANG_COEF;
    }
    
    if(APP_PARAMETERS.SAMPLES_CURRENT_LIN_COEF.bytes[0] == 0xff && APP_PARAMETERS.SAMPLES_CURRENT_LIN_COEF.bytes[1] == 0xff && APP_PARAMETERS.SAMPLES_CURRENT_LIN_COEF.bytes[2] == 0xff && APP_PARAMETERS.SAMPLES_CURRENT_LIN_COEF.bytes[3] == 0xff){
        APP_PARAMETERS.SAMPLES_CURRENT_LIN_COEF.floatValue = DEFAULT_SAMPLES_CURRENT_LIN_COEF;
    }
    
    if(((char *)&APP_PARAMETERS.ENABLE_LOAD_PROFILE)[0] == 0xff && ((char *)&APP_PARAMETERS.ENABLE_LOAD_PROFILE)[1] == 0xff && ((char *)&APP_PARAMETERS.ENABLE_LOAD_PROFILE)[2] == 0xff && ((char *)&APP_PARAMETERS.ENABLE_LOAD_PROFILE)[3] == 0xff){
        APP_PARAMETERS.ENABLE_LOAD_PROFILE = DEFAULT_ENABLE_LOAD_PROFILE;
    }
    
    if(((char *)&APP_PARAMETERS.DISCOVERY_DELAY_ANG_COEF_MS)[0] == 0xff && ((char *)&APP_PARAMETERS.DISCOVERY_DELAY_ANG_COEF_MS)[1] == 0xff && ((char *)&APP_PARAMETERS.DISCOVERY_DELAY_ANG_COEF_MS)[2] == 0xff && ((char *)&APP_PARAMETERS.DISCOVERY_DELAY_ANG_COEF_MS)[3] == 0xff){
        APP_PARAMETERS.DISCOVERY_DELAY_ANG_COEF_MS = DEFAULT_DISCOVERY_DELAY_ANG_COEF_MS;
    }
    
    if(((char *)&APP_PARAMETERS.DISCOVERY_DELAY_LIN_COEF_MS)[0] == 0xff && ((char *)&APP_PARAMETERS.DISCOVERY_DELAY_LIN_COEF_MS)[1] == 0xff && ((char *)&APP_PARAMETERS.DISCOVERY_DELAY_LIN_COEF_MS)[2] == 0xff && ((char *)&APP_PARAMETERS.DISCOVERY_DELAY_LIN_COEF_MS)[3] == 0xff){
        APP_PARAMETERS.DISCOVERY_DELAY_LIN_COEF_MS = DEFAULT_DISCOVERY_DELAY_LIN_COEF_MS;
    }
    
    if(((char *)&APP_PARAMETERS.ANNOUNCE_INTERVAL_S)[0] == 0xff && ((char *)&APP_PARAMETERS.ANNOUNCE_INTERVAL_S)[1] == 0xff && ((char *)&APP_PARAMETERS.ANNOUNCE_INTERVAL_S)[2] == 0xff && ((char *)&APP_PARAMETERS.ANNOUNCE_INTERVAL_S)[3] == 0xff){
        APP_PARAMETERS.ANNOUNCE_INTERVAL_S = DEFAULT_ANNOUNCE_INTERVAL_S;
    }

}

bool isAlarmEnabled(int alarm){
    return (APP_PARAMETERS.ENABLE_ALARMS & (1 << alarm)) > 0;
}

bool getAlarmState(int alarm){
    return (APP_PARAMETERS.ALARMS_STATES & (1 << alarm)) > 0;
}

void setAlarmState(int alarm, bool state){
    if(state){
        APP_PARAMETERS.ALARMS_STATES |= (1 << alarm);
    } else{
        APP_PARAMETERS.ALARMS_STATES &= ~(1 << alarm);
    }
    if(!param.saveParameters()){
        DEBUG(printf("[Param] Error writing alarm states (alarm %d)\r\n", alarm));
    }
}
