#include "announce.h"

Announce::Announce(){
    announceDelayAngCoef = 1;
    announceDelayLinCoef = 0;
    announceIntervalSec = 600;
    silenceIntervalSec = 2;
    sendNow = false;
}

void Announce::setDelayCoefs(int delayAngCoef, int delayLinCoef){
    announceDelayAngCoef = delayAngCoef;
    announceDelayLinCoef = delayLinCoef;
}

void Announce::setIntervals(int announce, int silence){
    announceIntervalSec = announce;
    silenceIntervalSec = silence;
}

void Announce::startAnnounceTimer(){
    announceBuffer[0] = PREAMBULO1;
    announceBuffer[1] = PREAMBULO2;
    announceBuffer[2] = TAMANHO_ENDERECO + TAMANHO_ENDERECO + 2 + MEDIDOR_LENGTH;  // 25
    
    for(int i=0; i < TAMANHO_ENDERECO; i++){
        announceBuffer[i+3] = ((sn.get()[2*i+9] & 0x0f) << 4) | (sn.get()[2*i+10] & 0x0f);
    }
    
    for(int i=0; i < 8; i++){
        announceBuffer[i+11] = 0xff;
    }
    announceBuffer[19] = 0x00; // Numero de sequencia
    announceBuffer[20] = CMD_BUSCAR_CONCENTRADOR;
    
    delay = announceDelayAngCoef * (((sn.get()[23] & 0x0f)*10) + (sn.get()[24] & 0x0f)) + announceDelayLinCoef;   // Delay variavel de acordo com o numero de serie do modulo
    DEBUG(printf("[GGS] Sending announce in %d ms...\r\n", delay));
    
    announceTimeout.attach_us(this, &Announce::triggerAnnounceSending, delay*1000);
}

void Announce::stopAnnounceTimer(){
    announceTimeout.detach();
}

void Announce::triggerAnnounceSending(){
    sendNow = true;
}

void Announce::handleAnnounceSending(){
    if(!sendNow){
        return;
    }
    sendNow = false;
    
    if(exec.getTimerGGS() < (float)silenceIntervalSec){
        DEBUG(printf("[GGS] Network busy. Sending announce in %d ms...\r\n", delay));
        announceTimeout.attach_us(this, &Announce::triggerAnnounceSending, delay*1000);
        return;
    }
    
    announceBuffer[19]++;
    announceBuffer[19] %= 256;
#ifdef RAMAL    
    memcpy(announceBuffer+21, MEDIDOR_DEFAULT_SN, MEDIDOR_LENGTH);
#else
    memcpy(announceBuffer+21, pima.getMeterNumber(), MEDIDOR_LENGTH);
#endif    
    unsigned short int crc = getCRC(announceBuffer, 2, announceBuffer[2] + 1);
    announceBuffer[28] = crc%256; // CRC1
    announceBuffer[29] = crc/256; // CRC2
    enviaRespostaGGS(announceBuffer, 30);
    
    DEBUG(printf("[GGS] Sending new announce in %d s\r\n", announceIntervalSec + delay/1000));
    announceTimeout.attach_us(this, &Announce::triggerAnnounceSending, announceIntervalSec*1000*1000 + delay*1000);
}
