/* mbed library for the mbed Lab Board  128*32 pixel LCD
 * use C12832 controller
 * Copyright (c) 2012 Peter Drescher - DC2PD
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef CORE_H
#define CORE_H

#include <string>
#include "MMA7660.h"
#include "C12832.h"
#include "easy-connect.h"
#include "http_request.h"
//#include "select-demo.h"

/** This classe is being used to control the temperature program
  *
  */

class Core {
public:
    /** Create a Core object and initialise all the values
      *
      */
    Core();
    
    /** Plays the program, this is the heart of this class
      *
      */
    void    guard(void);
    
private:
    bool    doorIsOpening(void);
    void    displayMessageOnScreen(void);
    void    triggerAlarm(void);
    void    shutDownAlarm(void);
    void    updateInfoWithAPI(void);
    void    dumpResponsePut(HttpResponse *);
    void    dumpResponseGet(HttpResponse *);
    void    putRequest(void);
    void    getRequest(void);
    
    /** These are the variables used in the program
      *
      */
    bool                _quiet;
    std::string         _message;
    NetworkInterface*   _network;
};




#endif
