#include "Core.h"

// Speaker
PwmOut spkr(D6);

// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);

// Orientation
MMA7660 MMA(D14,D15);

// Led color
DigitalOut r(D5);
DigitalOut b(D8);
DigitalOut g(D9);

// Used for USB connection
Serial host(USBTX, USBRX);

Core::Core() {
    r = 1.0;
    b = 1.0;
    g = 1.0;
    _message = "Searching..";
    _quiet = true;
    host.baud(38400);
    
    _network = easy_connect(true);
    if (!_network) {
        printf("Cannot connect to the network, see serial output");
        return;
    }
}

bool Core::doorIsOpening() {
    if (MMA.x() > 0.2 || MMA.x() < -0.2) {
        return true;
    }
    return false;
}

void Core::displayMessageOnScreen() {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s", _message); // Around 60max
    printf("%s\n", _message);
}

void Core::triggerAlarm() {
    static bool state = true;
    
    if (state) {
        r = 0;
        g = 1;
        b = 1;
        spkr.period(1.0/1000);
        spkr=0.5;

    } else {
        r = 1;
        g = 1;
        b = 0;        
        spkr.period(1.0/500);
        spkr=0.5;
    }
    state = !state;
}

void Core::dumpResponseGet(HttpResponse* res) {    
    char *pch;
    char *cstr = new char[res->get_body_as_string().length() + 1];
    
    strcpy(cstr, res->get_body_as_string().c_str());
    pch = strtok (cstr,"{}:,");
    int i = 0;
    while (pch != NULL) {
        pch = strtok (NULL, "{}:,");
        if (i == 2) {
            _message = pch;
        } else if (i == 4) {
            if (strcmp(pch, "false") == 0) {
                _quiet = false;
            } else {
                _quiet = true;
            }
            
        }
        i++;
    }
}

void Core::getRequest() {
    HttpRequest* get_req = new HttpRequest(_network, HTTP_GET, "http://10.0.0.91:8080/api/alarms/room1");
    HttpResponse* get_res = get_req->send();
    
    if (!get_res) {
        printf("HttpRequest get failed (error code %d)\n", get_req->get_error());
        return;
    }

    dumpResponseGet(get_res);

    printf("\n end response get\n");
    delete get_req;
}

void Core::putRequest() {
    HttpRequest* put_req = new HttpRequest(_network, HTTP_PUT, "http://10.0.0.91:8080/api/alarms/room1");
    put_req->set_header("Content-Type", "application/json");

    const char body[] = "{\"message\":\"Warning - Intruder !\", \"quiet\":\"false\"}";

    HttpResponse* put_res = put_req->send(body, strlen(body));
    if (!put_res) {
        printf("HttpRequest put failed (error code %d)\n", put_req->get_error());
        return;
    }
    delete put_req;
}

void Core::shutDownAlarm(void) {
    r = 1;
    g = 1;
    b = 1;
    spkr=0;
}

void Core::guard(void) {
    // Inifinte loop
    while (1) {
        if (doorIsOpening()) {
            putRequest(); // Update infos from local to API
        }
        getRequest(); // Update infos from API to local
        if (_quiet == false) {
            triggerAlarm();
        } else {
            shutDownAlarm();
        }
        displayMessageOnScreen();
    wait(0.5);
    }
}

int main()
{
    Core *core = new Core();
    
    core->guard();
    delete core;
}