#include "mbed.h"
#include "HCSR04.h"
#include "mbed.h"
#include "TextLCD.h"
#define DEFAULT        0//no
#define ADAFRUIT       0//no
#define DFROBOT        0
#define LCM1602        0
#define YWROBOT        0
#define GYLCD          0//no
#define MJKDZ          0//no
#define SYDZ           1
#define WIDEHK         0//no
#define LCDPLUG        0//no

Serial pc(PA_2,PA_3); // tx, rx
//I2C i2c_lcd(PB_9, PB_8); // SDA, SCL
TextLCD lcd(PA_8, PC_11, PC_6, PC_7, PC_8, PC_9, TextLCD::LCD16x2); //Inicilizar la pantalla LCD (se considera una panalla de 16 caracteres X 2 Filas
//TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4);
//Serial pc(PA_2,PA_3);//     Puertos de comunicación serial a PC
DigitalOut Verde(PD_12); // Verde==> Distancia RECOMENDADA (<40)
DigitalOut Azul(PD_15);//   Azul ==> Distancia MENOR A RECOMENDADA (entre 20 y 40)
DigitalOut Naranja(PD_13);//Naranja> Distancia PELIGROSA (entre 4 y 20)
HCSR04 ultra(PB_4,PB_5);//  Sensor Ultrasónico (Trigger y Echo)
DigitalOut Rojo(PD_14);//   Respuesta Sensor infrarojo==> CHOQUE INMINENTE (menor a 4)
DigitalIn Infra(PB_3);//    Señal Sensor infrarojo
char *array[] = {     //    Defino Matriz de caracteres a mostrar
    "Entre 4 y 20",
    "Entre 20 y 40",
    "Mayor a 40",
    "Menor igual a 4"
};
int d; // Variable que almacenará la distancia

void setup()
{
    /* lcd.setBacklight(TextLCD::LightOn); // Retroiluminación de pantalla
     lcd.setCursor(TextLCD::CurOff_BlkOn);//Seteo cursor
     lcd.setUDC(0, (char *) udc_0);
     lcd.putc(0);
     lcd.setUDC(1, (char *) udc_1);
     lcd.putc(1);
     */
    lcd.cls();//limpia pantalla
    int col = 0;//definición columna
    int row = 0;//definición fila
    lcd.locate(col,row);//Ubiación del cursor
    lcd.printf("Inicializando...");// mensaje de Inicialización de pantalla
    wait(2);//Espere 2 segundos
    //Secuencia de Incilización
    row++;
    lcd.locate(col,row);
    lcd.printf("Inicializando...");
    wait(2);
    row++;
    lcd.locate(col,row);
    lcd.printf("Inicializando...");
    wait(2);
    row++;
    lcd.locate(col,row);
    lcd.printf("Inicializando...");
}
//Secuencia para mostrar distancia según su rango
void mostrar(char *str, int distancia)
{
    //lcd.setBacklight(TextLCD::LightOn);
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf(str);
    lcd.locate(0, 1);
    lcd.printf("Distancia: %d",distancia);
}
//Determinación de selector
char determinarSelector()
{
    char selector;
    if(Infra == 0) { //sensor infarojo detecta obstaculo
        d = 4;
        selector = 'd';
    } else if(Infra == 1) { //no detecta obstaculo
        d =ultra.distance(1);
        if(d>4 && d<=20) { //distamcia entre 4 y 20
            selector = 'a';
        } else if(d>20 && d<= 40) { //entre 20 y 40
            selector = 'b';
        } else if(d > 40) { //distacia mayor a 40
            selector = 'c';
        }
    }
    //pc.printf("selector: %c\r\n",selector);
   // pc.printf("Distancia: %d\r\n",d);

    return selector;
}
//rutina principal
int main()
{
    setup();
    pc.baud(115200); //    Velocidad de Transmisión
    pc.printf("Inicio\n");//Mensaje de Incio de lectura de diastanciaen en pantalla PC
    while(1) {  //         Para que se ejecute siempre
        char selector = determinarSelector();
        switch(selector) {
            case 'a' : //distancia entre 4 y 20
                Naranja = 1;
                Azul = 0;
                Verde = 0;
                Rojo = 0;
                mostrar(array[0], d);
                break;
            case 'b' ://dist. entre 20 y 40
                Azul   = 1;
                Naranja = 0;
                Verde = 0;
                Rojo = 0;
                mostrar(array[1], d);
                break;
            case 'c' :// dist. > 40
                Verde = 1;
                Azul = 0;
                Naranja = 0;
                Rojo = 0;
                mostrar(array[2], d);
                break;
            case 'd' :// entre 0 y 4
                Verde = 0;
                Azul = 0;
                Naranja = 0;
                Rojo = 1;
                mostrar(array[3], d);
                break;
            default :// Si no cae en ningún rango anterior; señal de alrma mal funcionamiento sensores (endendido de 4 leds al mismo tiempo).
                Verde = 1;
                Azul = 1;
                Naranja = 1;
                Rojo = 1;
                break;
        }
        wait(1); //Espere 5 seg
    }

}