#include "mbed.h"
#include "math.h"
#include "EFI-Engine-Simulator.h"

unsigned short crank_angle = 0;
float targetRPM = EFI_CRANKING_RPM;
float offsetRPM = 0.0f;
Ticker RPMtick;

void updateSignals() {
    LPC_GPIO2->FIOPIN = EFI_CRANK_CAM_LOOKUP[crank_angle] << 4;
    crank_angle++;
    if (crank_angle >= EFI_TOTAL_ROTATION) { crank_angle = 0; }
}

int main() {
    // Set up pins p21 (P2_5) and p22 (P2_4) at a low level
    LPC_PINCON->PINSEL4 &= 0xFFFFF0FF; // Set pins to GPIO (function = 0b00)
    LPC_PINCON->PINMODE_OD2 |= 3 << 4; // Set pins to open drain mode
    LPC_GPIO2->FIODIR |= 3 << 4;       // Set pins as outputs (dir = 1)
    LPC_GPIO2->FIOMASK = ~(3 << 4);    // Only change these pins (mask bits = 0)

    // Main loop - simple cycling of RPMs to test crank / cam signals
    while(1) {
        targetRPM = (EFI_REDLINE_RPM / 2.0f) + (sin(offsetRPM) * ((EFI_REDLINE_RPM / 2.0f)));
        RPMtick.attach(&updateSignals, 1.0f / (targetRPM * 6));
        offsetRPM += 0.05f;
        wait_ms(100);
    }
}