/*
EFI-Engine-Simulator.h - Header file for EFI Engine Simulator

The purpose of this program is to simulate the CPS (Crank Position Sensor) and
the CAS (Crank Angle Sensor) of a "traditional" 4-stroke engine for testing
Electronic Fuel Injection engine computers (aka the EFI ECU or PCM).

Initially this project will be used to simulate one of the following engines, 
but it's hoped that this will expand over time - if you want to help, email me.

* Mitsubishi 6G72 DOHC - Used in the GTO / 3000GT and Dodge Stealth equivalent
* Mitsubishi 6A13 DOHC - Used in the 8th Gen Galant VR-4 / Legnum

Both of these cars use a hall-effect 3-vane CPS and 4-vane CAS, details can be
found here; https://www.stealth316.com/2-ignitionsystem.htm

The above car manufacturers, models and content are copyrights / trademarks of
their respective owners.

This program is provided as-is, without any warranty or support. You use it at
your own risk. I take no responsibility for any damages that may occur.

This program is provided free for educational and personal use but please credit
the same people I have credited.

It may also be used directly or indirectly for commercial purposes ONLY IF a
a 5% donation of any profits is made to a charity that can be categorised below;

* One that helps animals, particularly endangered species
* One that helps humanity with terminal illness ie. ALS / MND, cancers etc
* One that helps young people learn computing, cars and / or engineering

Let's give a little back to the community, even if it's just a few bucks :)

Credits:

* http://www.stealth316.com/ - Ignition timing information for the 6G72 / 6A13
* Kewks - For recommending setting pin states directly for extra performance
* The open-source programming community at large for all the inspiration

Jason Gaunt, 22nd April 2019
*/

#ifndef EFI_H
#define EFI_H

#define EFI_STALL_RPM      100
#define EFI_CRANKING_RPM   200
#define EFI_IDLE_SPEED_RPM 800
#define EFI_REDLINE_RPM    8000

#define EFI_TOTAL_ROTATION 720 // Degrees

/*
Here we define the lookup table for crank and cam angle, each row is one degree,
starting at 0 degrees, with the numerical value indicating one of the following:

* 0 = both cam and crank angle sensor values are low
* 1 = cam sensor signal is high, crank is low
* 2 = cam sensor signal is low, crank is high
* 3 = both cam and crank angle sensor values are high

These can be used to set port values directly (or indirectly using bitfield ops)
*/

static char EFI_CRANK_CAM_LOOKUP[EFI_TOTAL_ROTATION] = {
    1, // 0 degree(s)
    1, // 1 degree(s)
    1, // 2 degree(s)
    1, // 3 degree(s)
    1, // 4 degree(s)
    1, // 5 degree(s)
    1, // 6 degree(s)
    1, // 7 degree(s)
    1, // 8 degree(s)
    1, // 9 degree(s)
    3, // 10 degree(s)
    3, // 11 degree(s)
    3, // 12 degree(s)
    3, // 13 degree(s)
    3, // 14 degree(s)
    3, // 15 degree(s)
    3, // 16 degree(s)
    3, // 17 degree(s)
    3, // 18 degree(s)
    3, // 19 degree(s)
    3, // 20 degree(s)
    3, // 21 degree(s)
    3, // 22 degree(s)
    3, // 23 degree(s)
    3, // 24 degree(s)
    3, // 25 degree(s)
    3, // 26 degree(s)
    3, // 27 degree(s)
    3, // 28 degree(s)
    3, // 29 degree(s)
    3, // 30 degree(s)
    3, // 31 degree(s)
    3, // 32 degree(s)
    3, // 33 degree(s)
    3, // 34 degree(s)
    3, // 35 degree(s)
    3, // 36 degree(s)
    3, // 37 degree(s)
    3, // 38 degree(s)
    3, // 39 degree(s)
    3, // 40 degree(s)
    3, // 41 degree(s)
    3, // 42 degree(s)
    3, // 43 degree(s)
    3, // 44 degree(s)
    3, // 45 degree(s)
    3, // 46 degree(s)
    3, // 47 degree(s)
    3, // 48 degree(s)
    3, // 49 degree(s)
    3, // 50 degree(s)
    3, // 51 degree(s)
    3, // 52 degree(s)
    3, // 53 degree(s)
    3, // 54 degree(s)
    3, // 55 degree(s)
    3, // 56 degree(s)
    3, // 57 degree(s)
    3, // 58 degree(s)
    3, // 59 degree(s)
    3, // 60 degree(s)
    1, // 61 degree(s)
    1, // 62 degree(s)
    1, // 63 degree(s)
    1, // 64 degree(s)
    1, // 65 degree(s)
    1, // 66 degree(s)
    1, // 67 degree(s)
    1, // 68 degree(s)
    1, // 69 degree(s)
    1, // 70 degree(s)
    1, // 71 degree(s)
    1, // 72 degree(s)
    1, // 73 degree(s)
    1, // 74 degree(s)
    1, // 75 degree(s)
    1, // 76 degree(s)
    1, // 77 degree(s)
    1, // 78 degree(s)
    1, // 79 degree(s)
    1, // 80 degree(s)
    1, // 81 degree(s)
    1, // 82 degree(s)
    1, // 83 degree(s)
    1, // 84 degree(s)
    1, // 85 degree(s)
    0, // 86 degree(s)
    0, // 87 degree(s)
    0, // 88 degree(s)
    0, // 89 degree(s)
    0, // 90 degree(s)
    0, // 91 degree(s)
    0, // 92 degree(s)
    0, // 93 degree(s)
    0, // 94 degree(s)
    0, // 95 degree(s)
    0, // 96 degree(s)
    0, // 97 degree(s)
    0, // 98 degree(s)
    0, // 99 degree(s)
    0, // 100 degree(s)
    0, // 101 degree(s)
    0, // 102 degree(s)
    0, // 103 degree(s)
    0, // 104 degree(s)
    0, // 105 degree(s)
    0, // 106 degree(s)
    0, // 107 degree(s)
    0, // 108 degree(s)
    0, // 109 degree(s)
    0, // 110 degree(s)
    0, // 111 degree(s)
    0, // 112 degree(s)
    0, // 113 degree(s)
    0, // 114 degree(s)
    0, // 115 degree(s)
    0, // 116 degree(s)
    0, // 117 degree(s)
    0, // 118 degree(s)
    0, // 119 degree(s)
    0, // 120 degree(s)
    0, // 121 degree(s)
    0, // 122 degree(s)
    0, // 123 degree(s)
    0, // 124 degree(s)
    0, // 125 degree(s)
    0, // 126 degree(s)
    0, // 127 degree(s)
    0, // 128 degree(s)
    0, // 129 degree(s)
    2, // 130 degree(s)
    2, // 131 degree(s)
    2, // 132 degree(s)
    2, // 133 degree(s)
    2, // 134 degree(s)
    2, // 135 degree(s)
    2, // 136 degree(s)
    2, // 137 degree(s)
    2, // 138 degree(s)
    2, // 139 degree(s)
    2, // 140 degree(s)
    2, // 141 degree(s)
    2, // 142 degree(s)
    2, // 143 degree(s)
    2, // 144 degree(s)
    2, // 145 degree(s)
    2, // 146 degree(s)
    2, // 147 degree(s)
    2, // 148 degree(s)
    2, // 149 degree(s)
    2, // 150 degree(s)
    2, // 151 degree(s)
    2, // 152 degree(s)
    2, // 153 degree(s)
    2, // 154 degree(s)
    2, // 155 degree(s)
    2, // 156 degree(s)
    2, // 157 degree(s)
    2, // 158 degree(s)
    2, // 159 degree(s)
    2, // 160 degree(s)
    2, // 161 degree(s)
    2, // 162 degree(s)
    2, // 163 degree(s)
    2, // 164 degree(s)
    3, // 165 degree(s)
    3, // 166 degree(s)
    3, // 167 degree(s)
    3, // 168 degree(s)
    3, // 169 degree(s)
    3, // 170 degree(s)
    3, // 171 degree(s)
    3, // 172 degree(s)
    3, // 173 degree(s)
    3, // 174 degree(s)
    3, // 175 degree(s)
    3, // 176 degree(s)
    3, // 177 degree(s)
    3, // 178 degree(s)
    3, // 179 degree(s)
    3, // 180 degree(s)
    1, // 181 degree(s)
    1, // 182 degree(s)
    1, // 183 degree(s)
    1, // 184 degree(s)
    1, // 185 degree(s)
    1, // 186 degree(s)
    1, // 187 degree(s)
    1, // 188 degree(s)
    1, // 189 degree(s)
    1, // 190 degree(s)
    1, // 191 degree(s)
    1, // 192 degree(s)
    1, // 193 degree(s)
    1, // 194 degree(s)
    1, // 195 degree(s)
    1, // 196 degree(s)
    1, // 197 degree(s)
    1, // 198 degree(s)
    1, // 199 degree(s)
    1, // 200 degree(s)
    1, // 201 degree(s)
    1, // 202 degree(s)
    1, // 203 degree(s)
    1, // 204 degree(s)
    1, // 205 degree(s)
    0, // 206 degree(s)
    0, // 207 degree(s)
    0, // 208 degree(s)
    0, // 209 degree(s)
    0, // 210 degree(s)
    0, // 211 degree(s)
    0, // 212 degree(s)
    0, // 213 degree(s)
    0, // 214 degree(s)
    0, // 215 degree(s)
    0, // 216 degree(s)
    0, // 217 degree(s)
    0, // 218 degree(s)
    0, // 219 degree(s)
    0, // 220 degree(s)
    0, // 221 degree(s)
    0, // 222 degree(s)
    0, // 223 degree(s)
    0, // 224 degree(s)
    0, // 225 degree(s)
    0, // 226 degree(s)
    0, // 227 degree(s)
    0, // 228 degree(s)
    0, // 229 degree(s)
    0, // 230 degree(s)
    0, // 231 degree(s)
    0, // 232 degree(s)
    0, // 233 degree(s)
    0, // 234 degree(s)
    0, // 235 degree(s)
    0, // 236 degree(s)
    0, // 237 degree(s)
    0, // 238 degree(s)
    0, // 239 degree(s)
    0, // 240 degree(s)
    0, // 241 degree(s)
    0, // 242 degree(s)
    0, // 243 degree(s)
    0, // 244 degree(s)
    0, // 245 degree(s)
    0, // 246 degree(s)
    0, // 247 degree(s)
    0, // 248 degree(s)
    0, // 249 degree(s)
    2, // 250 degree(s)
    2, // 251 degree(s)
    2, // 252 degree(s)
    2, // 253 degree(s)
    2, // 254 degree(s)
    2, // 255 degree(s)
    2, // 256 degree(s)
    2, // 257 degree(s)
    2, // 258 degree(s)
    2, // 259 degree(s)
    2, // 260 degree(s)
    2, // 261 degree(s)
    2, // 262 degree(s)
    2, // 263 degree(s)
    2, // 264 degree(s)
    2, // 265 degree(s)
    2, // 266 degree(s)
    2, // 267 degree(s)
    2, // 268 degree(s)
    2, // 269 degree(s)
    2, // 270 degree(s)
    2, // 271 degree(s)
    2, // 272 degree(s)
    2, // 273 degree(s)
    2, // 274 degree(s)
    2, // 275 degree(s)
    2, // 276 degree(s)
    2, // 277 degree(s)
    2, // 278 degree(s)
    2, // 279 degree(s)
    2, // 280 degree(s)
    2, // 281 degree(s)
    2, // 282 degree(s)
    2, // 283 degree(s)
    2, // 284 degree(s)
    2, // 285 degree(s)
    2, // 286 degree(s)
    2, // 287 degree(s)
    2, // 288 degree(s)
    2, // 289 degree(s)
    2, // 290 degree(s)
    2, // 291 degree(s)
    2, // 292 degree(s)
    2, // 293 degree(s)
    2, // 294 degree(s)
    2, // 295 degree(s)
    2, // 296 degree(s)
    2, // 297 degree(s)
    2, // 298 degree(s)
    2, // 299 degree(s)
    2, // 300 degree(s)
    0, // 301 degree(s)
    0, // 302 degree(s)
    0, // 303 degree(s)
    0, // 304 degree(s)
    0, // 305 degree(s)
    0, // 306 degree(s)
    0, // 307 degree(s)
    0, // 308 degree(s)
    0, // 309 degree(s)
    0, // 310 degree(s)
    0, // 311 degree(s)
    0, // 312 degree(s)
    0, // 313 degree(s)
    0, // 314 degree(s)
    0, // 315 degree(s)
    0, // 316 degree(s)
    0, // 317 degree(s)
    0, // 318 degree(s)
    0, // 319 degree(s)
    0, // 320 degree(s)
    0, // 321 degree(s)
    0, // 322 degree(s)
    0, // 323 degree(s)
    0, // 324 degree(s)
    0, // 325 degree(s)
    0, // 326 degree(s)
    0, // 327 degree(s)
    0, // 328 degree(s)
    0, // 329 degree(s)
    0, // 330 degree(s)
    0, // 331 degree(s)
    0, // 332 degree(s)
    0, // 333 degree(s)
    0, // 334 degree(s)
    0, // 335 degree(s)
    0, // 336 degree(s)
    0, // 337 degree(s)
    0, // 338 degree(s)
    0, // 339 degree(s)
    0, // 340 degree(s)
    0, // 341 degree(s)
    0, // 342 degree(s)
    0, // 343 degree(s)
    0, // 344 degree(s)
    0, // 345 degree(s)
    0, // 346 degree(s)
    0, // 347 degree(s)
    0, // 348 degree(s)
    0, // 349 degree(s)
    0, // 350 degree(s)
    0, // 351 degree(s)
    0, // 352 degree(s)
    0, // 353 degree(s)
    0, // 354 degree(s)
    1, // 355 degree(s)
    1, // 356 degree(s)
    1, // 357 degree(s)
    1, // 358 degree(s)
    1, // 359 degree(s)
    1, // 360 degree(s)
    1, // 361 degree(s)
    1, // 362 degree(s)
    1, // 363 degree(s)
    1, // 364 degree(s)
    1, // 365 degree(s)
    1, // 366 degree(s)
    1, // 367 degree(s)
    1, // 368 degree(s)
    1, // 369 degree(s)
    3, // 370 degree(s)
    3, // 371 degree(s)
    3, // 372 degree(s)
    3, // 373 degree(s)
    3, // 374 degree(s)
    3, // 375 degree(s)
    3, // 376 degree(s)
    3, // 377 degree(s)
    3, // 378 degree(s)
    3, // 379 degree(s)
    3, // 380 degree(s)
    3, // 381 degree(s)
    3, // 382 degree(s)
    3, // 383 degree(s)
    3, // 384 degree(s)
    3, // 385 degree(s)
    3, // 386 degree(s)
    3, // 387 degree(s)
    3, // 388 degree(s)
    3, // 389 degree(s)
    3, // 390 degree(s)
    3, // 391 degree(s)
    3, // 392 degree(s)
    3, // 393 degree(s)
    3, // 394 degree(s)
    3, // 395 degree(s)
    2, // 396 degree(s)
    2, // 397 degree(s)
    2, // 398 degree(s)
    2, // 399 degree(s)
    2, // 400 degree(s)
    2, // 401 degree(s)
    2, // 402 degree(s)
    2, // 403 degree(s)
    2, // 404 degree(s)
    2, // 405 degree(s)
    2, // 406 degree(s)
    2, // 407 degree(s)
    2, // 408 degree(s)
    2, // 409 degree(s)
    2, // 410 degree(s)
    2, // 411 degree(s)
    2, // 412 degree(s)
    2, // 413 degree(s)
    2, // 414 degree(s)
    2, // 415 degree(s)
    2, // 416 degree(s)
    2, // 417 degree(s)
    2, // 418 degree(s)
    2, // 419 degree(s)
    2, // 420 degree(s)
    0, // 421 degree(s)
    0, // 422 degree(s)
    0, // 423 degree(s)
    0, // 424 degree(s)
    0, // 425 degree(s)
    0, // 426 degree(s)
    0, // 427 degree(s)
    0, // 428 degree(s)
    0, // 429 degree(s)
    0, // 430 degree(s)
    0, // 431 degree(s)
    0, // 432 degree(s)
    0, // 433 degree(s)
    0, // 434 degree(s)
    0, // 435 degree(s)
    0, // 436 degree(s)
    0, // 437 degree(s)
    0, // 438 degree(s)
    0, // 439 degree(s)
    0, // 440 degree(s)
    0, // 441 degree(s)
    0, // 442 degree(s)
    0, // 443 degree(s)
    0, // 444 degree(s)
    0, // 445 degree(s)
    0, // 446 degree(s)
    0, // 447 degree(s)
    0, // 448 degree(s)
    0, // 449 degree(s)
    0, // 450 degree(s)
    0, // 451 degree(s)
    0, // 452 degree(s)
    0, // 453 degree(s)
    0, // 454 degree(s)
    0, // 455 degree(s)
    0, // 456 degree(s)
    0, // 457 degree(s)
    0, // 458 degree(s)
    0, // 459 degree(s)
    0, // 460 degree(s)
    0, // 461 degree(s)
    0, // 462 degree(s)
    0, // 463 degree(s)
    0, // 464 degree(s)
    0, // 465 degree(s)
    0, // 466 degree(s)
    0, // 467 degree(s)
    0, // 468 degree(s)
    0, // 469 degree(s)
    0, // 470 degree(s)
    0, // 471 degree(s)
    0, // 472 degree(s)
    0, // 473 degree(s)
    0, // 474 degree(s)
    0, // 475 degree(s)
    0, // 476 degree(s)
    0, // 477 degree(s)
    0, // 478 degree(s)
    0, // 479 degree(s)
    0, // 480 degree(s)
    0, // 481 degree(s)
    0, // 482 degree(s)
    0, // 483 degree(s)
    0, // 484 degree(s)
    0, // 485 degree(s)
    0, // 486 degree(s)
    0, // 487 degree(s)
    0, // 488 degree(s)
    0, // 489 degree(s)
    2, // 490 degree(s)
    2, // 491 degree(s)
    2, // 492 degree(s)
    2, // 493 degree(s)
    2, // 494 degree(s)
    2, // 495 degree(s)
    2, // 496 degree(s)
    2, // 497 degree(s)
    2, // 498 degree(s)
    2, // 499 degree(s)
    2, // 500 degree(s)
    2, // 501 degree(s)
    2, // 502 degree(s)
    2, // 503 degree(s)
    2, // 504 degree(s)
    2, // 505 degree(s)
    2, // 506 degree(s)
    2, // 507 degree(s)
    2, // 508 degree(s)
    2, // 509 degree(s)
    2, // 510 degree(s)
    2, // 511 degree(s)
    2, // 512 degree(s)
    2, // 513 degree(s)
    2, // 514 degree(s)
    2, // 515 degree(s)
    2, // 516 degree(s)
    2, // 517 degree(s)
    2, // 518 degree(s)
    2, // 519 degree(s)
    2, // 520 degree(s)
    2, // 521 degree(s)
    2, // 522 degree(s)
    2, // 523 degree(s)
    2, // 524 degree(s)
    3, // 525 degree(s)
    3, // 526 degree(s)
    3, // 527 degree(s)
    3, // 528 degree(s)
    3, // 529 degree(s)
    3, // 530 degree(s)
    3, // 531 degree(s)
    3, // 532 degree(s)
    3, // 533 degree(s)
    3, // 534 degree(s)
    3, // 535 degree(s)
    3, // 536 degree(s)
    3, // 537 degree(s)
    3, // 538 degree(s)
    3, // 539 degree(s)
    3, // 540 degree(s)
    1, // 541 degree(s)
    1, // 542 degree(s)
    1, // 543 degree(s)
    1, // 544 degree(s)
    1, // 545 degree(s)
    1, // 546 degree(s)
    1, // 547 degree(s)
    1, // 548 degree(s)
    1, // 549 degree(s)
    1, // 550 degree(s)
    1, // 551 degree(s)
    1, // 552 degree(s)
    1, // 553 degree(s)
    1, // 554 degree(s)
    1, // 555 degree(s)
    1, // 556 degree(s)
    1, // 557 degree(s)
    1, // 558 degree(s)
    1, // 559 degree(s)
    1, // 560 degree(s)
    1, // 561 degree(s)
    1, // 562 degree(s)
    1, // 563 degree(s)
    1, // 564 degree(s)
    1, // 565 degree(s)
    0, // 566 degree(s)
    0, // 567 degree(s)
    0, // 568 degree(s)
    0, // 569 degree(s)
    0, // 570 degree(s)
    0, // 571 degree(s)
    0, // 572 degree(s)
    0, // 573 degree(s)
    0, // 574 degree(s)
    0, // 575 degree(s)
    0, // 576 degree(s)
    0, // 577 degree(s)
    0, // 578 degree(s)
    0, // 579 degree(s)
    0, // 580 degree(s)
    0, // 581 degree(s)
    0, // 582 degree(s)
    0, // 583 degree(s)
    0, // 584 degree(s)
    0, // 585 degree(s)
    0, // 586 degree(s)
    0, // 587 degree(s)
    0, // 588 degree(s)
    0, // 589 degree(s)
    0, // 590 degree(s)
    0, // 591 degree(s)
    0, // 592 degree(s)
    0, // 593 degree(s)
    0, // 594 degree(s)
    0, // 595 degree(s)
    0, // 596 degree(s)
    0, // 597 degree(s)
    0, // 598 degree(s)
    0, // 599 degree(s)
    0, // 600 degree(s)
    0, // 601 degree(s)
    0, // 602 degree(s)
    0, // 603 degree(s)
    0, // 604 degree(s)
    0, // 605 degree(s)
    0, // 606 degree(s)
    0, // 607 degree(s)
    0, // 608 degree(s)
    0, // 609 degree(s)
    2, // 610 degree(s)
    2, // 611 degree(s)
    2, // 612 degree(s)
    2, // 613 degree(s)
    2, // 614 degree(s)
    2, // 615 degree(s)
    2, // 616 degree(s)
    2, // 617 degree(s)
    2, // 618 degree(s)
    2, // 619 degree(s)
    2, // 620 degree(s)
    2, // 621 degree(s)
    2, // 622 degree(s)
    2, // 623 degree(s)
    2, // 624 degree(s)
    2, // 625 degree(s)
    2, // 626 degree(s)
    2, // 627 degree(s)
    2, // 628 degree(s)
    2, // 629 degree(s)
    2, // 630 degree(s)
    2, // 631 degree(s)
    2, // 632 degree(s)
    2, // 633 degree(s)
    2, // 634 degree(s)
    2, // 635 degree(s)
    2, // 636 degree(s)
    2, // 637 degree(s)
    2, // 638 degree(s)
    2, // 639 degree(s)
    2, // 640 degree(s)
    2, // 641 degree(s)
    2, // 642 degree(s)
    2, // 643 degree(s)
    2, // 644 degree(s)
    2, // 645 degree(s)
    2, // 646 degree(s)
    2, // 647 degree(s)
    2, // 648 degree(s)
    2, // 649 degree(s)
    2, // 650 degree(s)
    2, // 651 degree(s)
    2, // 652 degree(s)
    2, // 653 degree(s)
    2, // 654 degree(s)
    2, // 655 degree(s)
    2, // 656 degree(s)
    2, // 657 degree(s)
    2, // 658 degree(s)
    2, // 659 degree(s)
    2, // 660 degree(s)
    0, // 661 degree(s)
    0, // 662 degree(s)
    0, // 663 degree(s)
    0, // 664 degree(s)
    0, // 665 degree(s)
    0, // 666 degree(s)
    0, // 667 degree(s)
    0, // 668 degree(s)
    0, // 669 degree(s)
    0, // 670 degree(s)
    0, // 671 degree(s)
    0, // 672 degree(s)
    0, // 673 degree(s)
    0, // 674 degree(s)
    0, // 675 degree(s)
    0, // 676 degree(s)
    0, // 677 degree(s)
    0, // 678 degree(s)
    0, // 679 degree(s)
    0, // 680 degree(s)
    0, // 681 degree(s)
    0, // 682 degree(s)
    0, // 683 degree(s)
    0, // 684 degree(s)
    0, // 685 degree(s)
    0, // 686 degree(s)
    0, // 687 degree(s)
    0, // 688 degree(s)
    0, // 689 degree(s)
    0, // 690 degree(s)
    0, // 691 degree(s)
    0, // 692 degree(s)
    0, // 693 degree(s)
    0, // 694 degree(s)
    0, // 695 degree(s)
    0, // 696 degree(s)
    0, // 697 degree(s)
    0, // 698 degree(s)
    0, // 699 degree(s)
    0, // 700 degree(s)
    0, // 701 degree(s)
    0, // 702 degree(s)
    0, // 703 degree(s)
    0, // 704 degree(s)
    0, // 705 degree(s)
    0, // 706 degree(s)
    0, // 707 degree(s)
    0, // 708 degree(s)
    0, // 709 degree(s)
    0, // 710 degree(s)
    0, // 711 degree(s)
    0, // 712 degree(s)
    0, // 713 degree(s)
    0, // 714 degree(s)
    0, // 715 degree(s)
    0, // 716 degree(s)
    0, // 717 degree(s)
    0, // 718 degree(s)
    0  // 719 degree(s)
};

#endif // EFI_H