#include "mbed.h"
#include "Menu.h"
#include "Selection.h"

Menu::Menu(char *id) : menuID(id), parent(NULL),update_needed(1)
{
    selections.clear();
}

Menu::Menu(string id) : menuID(id), parent(NULL),update_needed(1)
{
    selections.clear();
}

void Menu::add(const Selection &toAdd)
{
    selections.push_back(toAdd);
}


void Menu::select(void)
{
}

void Menu::display(LCD * lcd)
{
    lcd->writeLine(0,"Default Menu");
#if 0  
    for ( int i=0; i< lcd->rows();i++)
    {   
        if ( i < selections.size())
        {
            //if (i==cursorLine) {
            //    lcd->character(i,0,'>');
            //}
            fprintf(stdout, "(%d) i = %s\n\r", selections[i].getText());
            lcd->writeLine(i,selections[i].getText());
        }
    }
#endif
}


void Menu::moveUp()
{        
    cursorLine--;
    if (cursorLine < 0 ) {
        cursorLine = lcd->rows() -1 ;
        //if (top > 0 ) top -=4; // page menu if needed
    }
     
       
    if(cursorPos > 0)
    {
        cursorPos--;
    } 
    
    printCursor();
    //printMenu();
    
    
    printf ("UP:%d %d ", cursorLine , cursorPos );
}

void Menu::moveDown()
{
    
    cursorLine++;
    if (cursorLine >= lcd->rows() ) {
        cursorLine = 0;
        //if (top < activeMenu->selections.size() ) top +=4; // page menu if needed
    }
     
    if(cursorPos < selections.size()){
        cursorPos++;
    }
    
    printCursor();
    //printMenu();
    
    printf ("DOWN:%d %d ", 
        cursorLine , cursorPos );
}

void Menu::pressMode()
{
    
}
        
void Menu::pressSet()
{
    
}

void Menu::pressUp()
{
    
}
        
void Menu::pressDown()
{
    
}


void Menu::pressClear()
{
    
}


void Menu::printMenu()
{ 
    for (int i=0;i<lcd->rows();i++)
    {
        if ((i) < selections.size())
        {
            lcd->writeLine(i,selections[i].selText);
        }
        else
        {   
            lcd->writeLine(i,"");
        }   
    }
    
    lcd->dump(NULL);
}

void Menu::printCursor()
{   

    for(int i=0;i<lcd->rows();i++)
    {
        lcd->locate(i,0);
            
        if (i==cursorLine) {
            lcd->character(i,0,'>');
        }
        else
        {
            lcd->character(i,0,' ');
        }
    }
    
    lcd->dump(NULL);
    
}
