#ifndef NAVIGATOR_H
#define NAVIGATOR_H

#include "mbed.h"
#include "Menu.h"
#include "LCD.h"

class Navigator {   
    private: 
               
    public:
        Navigator(Menu *, LCD *);
        //Navigator(Menu *, RPG &, TextLCD *);
        Menu *activeMenu; // the current menu - can change when RPG is pushed on selection with child menu

        LCD *lcd; 
        
        bool lastButton, button;
        int direction;  // 1 = CW, -1 = CCW
        
        int top;        // the index of the last item of current menu
        int bottom;     // the index of the last item of current menu
        
        int cursorPos;  // what selection the cursor points to
        int cursorLine; // what line of the lcd the cursor is one
        
        void update(char cmd);    // repeatedly call this function to determine if RPG is being used
        void moveUp();
        void moveDown();
        void selectMenu();
        void printMenu();
        void printCursor();
        
        void pageUp ();
        void pageDown ();
};

#endif 