#include "Navigator.h"
/*
Navigator::Navigator(Menu *root, RPG &rpg, TextLCD *lcd) : activeMenu(root), rpg(rpg), lcd(lcd) 
{
    bottom = root->selections.size();
    cursorPos = 0;
    cursorLine = 1;
    button = 0;
    lastButton = 0;
    
    printMenu();
    printCursor();
}
*/
Navigator::Navigator(Menu *root, LCD *lcd) : activeMenu(root),  lcd(lcd) 
{
    top = 0;
    bottom = root->selections.size();
    cursorPos = 0;
    cursorLine = 0;
    button = 0;
    lastButton = 0;
}
void Navigator::printMenu()
{ 
    for (int i=0;i<lcd->rows();i++)
    {
        if ((top+i) < activeMenu->selections.size())
        {
            lcd->writeLine(i,activeMenu->selections[top+i].selText);
        }
        else
        {   
            lcd->writeLine(i,"");
        }   
    }
    
    lcd->dump(NULL);
}

void Navigator::printCursor()
{   

    
    int tmp = activeMenu->selections.size() - cursorPos; 
    fprintf(stdout,"%d %d %d \n\r", tmp, cursorPos, activeMenu->selections.size() );
    
    for(int i=0;i<lcd->rows();i++)
    {
        lcd->locate(i,0);
            
        if (i==cursorLine) {
            lcd->character(i,0,'>');
        }
        else
        {
            lcd->character(i,0,' ');
        }
    }
    
    lcd->dump(NULL);
    
}
        

void Navigator::selectMenu()
{
    
    printf ("SEL:%d %d ", 
        cursorLine , cursorPos );
        
    if(activeMenu->selections[cursorPos].childMenu != NULL)
    {
        activeMenu = activeMenu->selections[cursorPos].childMenu;

        cursorPos = 0;
        cursorLine = 0;
        
        printMenu();
        printCursor();
    }
    else
    {
        activeMenu->selections[cursorPos].select();
    }

    

    
}
        
void Navigator::update(char cmd)
{
    /*
    switch (cmd)
        {
            case 'U' :
            case 'u' :
                moveUp();
                break;
            case 'D' :
            case 'd' :
                moveDown();
                break;
            case 'a' :
            case 'A' :
            case '0x32' :
                if(activeMenu->selections[cursorPos].fun != NULL)
                {
                    (activeMenu->selections[cursorPos].fun)();
                }
                if(activeMenu->selections[cursorPos].childMenu != NULL)
                {
                    activeMenu = activeMenu->selections[cursorPos].childMenu;
                    bottom = activeMenu->selections.size();
                    cursorPos = 0;
                    cursorLine = 1;
                    printMenu();
                    printCursor();
                }
                break;
            default:
                break;
    };
    */
    
    
    /*
    
    if((direction = rpg.dir())!=0){ //Get Dir
        wait(0.2); 
        if(direction == 1) moveDown();
        else if(direction == -1) moveUp();
    }
       
    if ((button = rpg.pb()) && !lastButton){ //prevents multiple selections when button is held down
        wait(0.2);
        if(activeMenu->selections[cursorPos].fun != NULL){
            (activeMenu->selections[cursorPos].fun)();
        }
        if(activeMenu->selections[cursorPos].childMenu != NULL){
            activeMenu = activeMenu->selections[cursorPos].childMenu;
            bottom = activeMenu->selections.size();
            cursorPos = 0;
            cursorLine = 1;
            printMenu();
            printCursor();
        }
    }
    */
    
    lastButton = button;
}

void Navigator::pageDown ()
{
    if(cursorPos < bottom  )
    {
        bottom -= lcd->rows();
        top    -= lcd->rows();
    } 
}

void Navigator::pageUp ()
{
    if(cursorPos >= top  )
    {
        bottom += lcd->rows();
        top    += lcd->rows();
    } 
}

void Navigator::moveUp()
{        
    cursorLine--;
    if (cursorLine < 0 ) {
        cursorLine = lcd->rows() -1 ;
        if (top > 0 ) top -=4; // page menu if needed
    }
     
       
    if(cursorPos > 0)
    {
        cursorPos--;
    } 
    
    printCursor();
    //printMenu();
    
    
    printf ("UP:%d %d ", cursorLine , cursorPos );
}

void Navigator::moveDown()
{
    
    cursorLine++;
    if (cursorLine >= lcd->rows() ) {
        cursorLine = 0;
        if (top < activeMenu->selections.size() ) top +=4; // page menu if needed
    }
     
    if(cursorPos < activeMenu->selections.size()){
        cursorPos++;
    }
    
    printCursor();
    //printMenu();
    
    printf ("DOWN:%d %d ", 
        cursorLine , cursorPos );
}