#include "mbed.h"
#include "EditTimeMenu.h"
#include "TimeUtilities.h"


RealTimeClock rtc;


EditTimeMenu::EditTimeMenu(string id): Menu(id)
{
   
    active_selection = 0;
    row=0;
    column=0;
    
    time_t rawtime;
    struct tm * timeinfo;
    
    time ( &rawtime );
    timeinfo = localtime ( &rawtime );  timeinfo = localtime (&rawtime);
                
    hours = timeinfo->tm_hour;
    mins  = timeinfo->tm_min;
    secs  = timeinfo->tm_sec;
    
    years   = timeinfo->tm_year + 1900;
    months  = timeinfo->tm_mon + 1 ;
    days    = timeinfo->tm_mday;
    
       
}
   


void EditTimeMenu::display(LCD * lcd)
{
    char     setTime = 1;
    char     setDate = 1;
    
    char current[40];
    
    time_t rawtime;
    struct tm * timeinfo;
    
    time ( &rawtime );
    timeinfo = localtime ( &rawtime );  timeinfo = localtime (&rawtime);
    
    if (!active_selection){
        hours = timeinfo->tm_hour;
        mins  = timeinfo->tm_min;
        secs  = timeinfo->tm_sec;
        years   = timeinfo->tm_year+1900;
        months  = timeinfo->tm_mon + 1;
        days    = timeinfo->tm_mday;
        lcd->setCursorMode (0) ;
    }
    else
    {
        // edit mode
        secs  = timeinfo->tm_sec;
        lcd->setCursorMode (1) ;
    }
    
    switch(active_selection)
    {
      case 1:  
         lcd->writeLine(0,"Set Time (hours) :");
         break;
      case 2:  
         lcd->writeLine(0,"Set Time (min) :");
         break;
      case 3:  
         lcd->writeLine(0,"Set Time (sec) :");
         break;
      case 4:  
         lcd->writeLine(0,"Set Date (month) :");
         break;
      case 5:  
         lcd->writeLine(0,"Set Date (day) :");
         break;
      case 6:  
         lcd->writeLine(0,"Set Date (year) :");
         break;
    default:
        lcd->writeLine(0,"Current Time/Date :");
        break;
    };
    //rtc.GetTimeString(buf);
    //sprintf(current,"%02d:%02d:%02d", timeinfo->tm_hour, timeinfo->tm_min, timeinfo->tm_sec);
    
    if (setTime) {
        sprintf(current,"%02d:%02d", hours,mins);
        lcd->writeLine(1,current);
    }
    
    if (setDate) {
        sprintf(current,"%02d/%02d/%02d", months, days, years);
        lcd->writeLine(2,current);
    }

        
}

void EditTimeMenu::pressMode()
{   
    // advance thru
    if (active_selection++ >  6 )
        active_selection = 0;
    
    update_needed = 1;
}
        
void EditTimeMenu::pressSet()
{
    
    struct tm t;
    
    t.tm_hour = hours;
    t.tm_min  = mins;
    t.tm_sec  = 0;
    
    t.tm_year = years - 1900;
    t.tm_mon  = months - 1;
    t.tm_mday = days;
    
    // set the time
    set_time(mktime(&t));

   
    // go back to normal display
    // ---------------------------------
    active_selection = 0;
    update_needed = 1;
}

void EditTimeMenu::pressUp()
{    
    switch(active_selection)
    {
        case 1: hours++;break;
        case 2: mins++;break;
        case 3: secs++;break;
        case 4: months++;break;
        case 5: days++;break;
        case 6: years++;break;
        default:break;
        
    }
    if (hours > 23)    hours  = 0;
    if (mins > 60)     mins   = 0;
    if (secs > 60)     secs   = 0;
    if (months > 12)   months  = 1;
    if (days > 31)     days    = 1;
    if (years > 2050) years  =2011;
    
    update_needed = 1;
}
        
void EditTimeMenu::pressDown()
{
    switch(active_selection)
    {
        case 1: hours--;break;
        case 2: mins--;break;
        case 3: secs--;break;
        case 4: months--;break;
        case 5: days--;break;
        case 6: years--;break;
        default:break;
        
    }
    
    if (hours < 0)    hours  += 23;
    if (mins < 0)     mins   += 60;
    if (secs < 0)     secs   += 60;
    if (months < 1)   months += 12;
    if (days < 1)     days   += 31;
    if (years < 2011) years  =2050;
        
    update_needed = 1;   
}
