#include "mbed.h"
#include "DisplayCodesMenu.h"
#include "TimeUtilities.h"


DisplayCodesMenu::DisplayCodesMenu(string id): Menu(id)
{
    
    active_selection = 0;
    row=0;
    column=0;
    update_needed=1;
    current_line=0;
    
}
   
void DisplayCodesMenu::display(LCD * lcd)
{
   
    char buf[40];

    if (update_needed)
    {
        
        lcd->cls();
        lcd->writeLine(0,"ID | ## | Time");   
#if 1      
        for(int i=0;i<3;i++)
        {
            int index = (current_line+i);
            int line  = (1+i);
            if (index < escmEventLog.size() )
            {
                sprintf(buf,"%02d | %02d | %-16s", 
                    index + 1,
                    escmEventLog.events[index].address,
                    escmEventLog.events[index].timeStr);   
                      
            } else {
                sprintf(buf,"%s | %s | %-16s",
                    "--",
                    "--",
                    "- N/A -");   
            }  
            
            lcd->writeLine(line,buf);     
        
        }
        update_needed=0;
#endif
    }
    
}

void DisplayCodesMenu::pressMode()
{   

}
        
void DisplayCodesMenu::pressSet()
{
    
}

void DisplayCodesMenu::pressDown()
{    
    printf("scroll down\n");
    if (current_line < escmEventLog.size() ) 
        current_line++;
    else
        current_line = escmEventLog.size()-1;
        
    update_needed=1;
}
        
void DisplayCodesMenu::pressUp()
{
    printf("scroll up\n");
    if (current_line > 0) 
        current_line--;
    else
        current_line = 0;
    
    update_needed =1;     
}
