#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "Selection.h"
#include "LCD.h"

#include <vector>
#include <string>

class Selection;

class Menu {
    private:
               
    public:
        
        LCD  * lcd;
        Menu * parent;
        
        int update_needed;
        
        int cursorPos;  // what selection the cursor points to
        int cursorLine; // what line of the lcd the cursor is one
    
        vector<Selection> selections;
        string menuID;
        
        Menu(char *id);
        Menu(string id);
        
    
        
        void add(const Selection &toAdd);
        
        virtual void select();
        
        //char * getText() { return menuID.c_str(); };
        
        virtual void display(LCD * lcd);
        
        void moveUp();
        void moveDown();
        
        virtual void pressClear();  
        virtual void pressMode();        
        virtual void pressSet();    
        virtual void pressDown();    
        virtual void pressUp();
        
        void printMenu();
        void printCursor();
        
};
#endif