#ifndef _BUTTON_CONTROLLER_
#define _BUTTON_CONTROLLER_

#include "mbed.h"
#include "rtos.h"
#include "mcp23s08.h"
#include "Menu.h"
#include "Navigator.h"

/**
 * service to manage the external GPIO expander board.
 */
typedef enum
{
    NO_BUTTON    = 27,
    BUTTON_UP    = 26,
    BUTTON_DOWN  = 25,
    BUTTON_MODE  = 19,
    BUTTON_SET   = 11,
    BUTTON_CLEAR = 0
} tButtonValue ;

typedef void (*t_ButtonPressCallback)(void);


/***
*
* This class wrapps the communication with the GPIO expander over SPI bus.
*  PIN 0 : Up
*  PIN 1 : Down
*  PIN 2 : Clear
*  PIN 3 : Mode
*  PIN 4 : Set
*  PIN 5 : Enable Audio
*  PIN 6 : na
*  PIN 7 : na 
*  
*  MASK = 0x1F;
*  
*/
class ButtonController 
{
    public :
        
        Navigator *     navigator;
        mcp23s08 *      spi_io_exp;
        Mutex           _mutex;
        unsigned char   currentValue;
        unsigned char   prevValue;
        unsigned char   confirmedValue;
        unsigned int    countsSinceChange;
        unsigned char   isServiced;
        unsigned char   isHeld;
        
        
        CircularBuffer<uint8_t, 64> cmd_queue;
        
        ButtonController(Navigator * navigator);
        ~ButtonController();
        
        void  pressButtonUp(void);
        void  pressButtonDown(void);
        void  pressButtonClear(void);
        void  pressButtonMode(void);
        void  pressButtonSet(void);
        void  releaseButton(void);
        
        void init(void);
        void update(void);
        void update(Navigator * navigator);
        void update(Menu * menu);
        void update(int currentValue, Menu * menu);
        
        uint8_t getCurrentState ();
};


#endif
