#include "ButtonController.h"


ButtonController::ButtonController(Navigator * navigator)
{
    
    spi_io_exp = new mcp23s08 (p5, p6, p7, p26, 0x20);
    
    // set pin modes
    // ---------------------------------------
    spi_io_exp->gpioPinMode(0,0);
    spi_io_exp->gpioPinMode(1,0);
    spi_io_exp->gpioPinMode(2,0);
    spi_io_exp->gpioPinMode(3,0);
    spi_io_exp->gpioPinMode(4,0);
    spi_io_exp->gpioPinMode(5,1);
    spi_io_exp->gpioPinMode(6,1);
    spi_io_exp->gpioPinMode(7,1);
    
    // enable the audio amplifier
    // ---------------------------------------
    spi_io_exp->gpioPinMode(5,1);
    spi_io_exp->gpioDigitalWrite(5,1);
    spi_io_exp->gpioDigitalWrite(6,0);
    spi_io_exp->gpioDigitalWrite(7,0);
    
    this->navigator = navigator;
}

ButtonController::~ButtonController()
{
    
}

void ButtonController::init(void)
{
    
}

void ButtonController::update(int currentValue, Menu * menu)
{
    switch(currentValue)
    {
        case 1:
            menu->pressUp();
            break;
        case 2:
            menu->pressDown();
            break;
        case 3:
            menu->pressMode();
            break;
        case 4:
            menu->pressSet();
            break;
        case 5:
            break;
        default:
            /* no action */
            printf("!Button Pressed:%d\n\r",currentValue);
            break;
    };
}

void ButtonController::update(Menu * menu)
{
    int trigger_action = 0;
    currentValue = spi_io_exp->readGpioPort();
    
    // if (raising edge | falling edge )
    if (currentValue != prevValue ) {
        prevValue = currentValue;
        countsSinceChange = 0;
        trigger_action = 1;

    }
    else
    {   //TODO: play with time for what is short or long hold
        countsSinceChange++;
        if ( currentValue != NO_BUTTON && countsSinceChange>=10000)
        {
            if (isHeld != 2) printf("Button Long Held:%d\n\r",currentValue);
            isHeld = 2;
            trigger_action = 1;
        }
        else if (currentValue != NO_BUTTON && countsSinceChange>=5000)
        {
            if (isHeld != 1) printf("Button Short Held:%d\n\r",currentValue);
            isHeld = 1;
            trigger_action = 1;
            countsSinceChange = 0;
        }
        else
        {
            isHeld =0;
        }
    }
    
    if (trigger_action || isHeld){
        switch(currentValue)
        {
            case BUTTON_UP:
                menu->pressUp();
                break;
            case BUTTON_DOWN:
                menu->pressDown();
                break;
            case BUTTON_MODE:
                menu->pressMode();
                break;
            case BUTTON_SET:
                menu->pressSet();
                break;
            case BUTTON_CLEAR:
                break;
            case NO_BUTTON:
                break;
            default:
                break;
        }
    }
}

uint8_t ButtonController::getCurrentState()
{
    currentValue = spi_io_exp->readGpioPort();
    
    return currentValue;
}

void ButtonController::update(Navigator * navigator)
{
    currentValue = spi_io_exp->readGpioPort();
    
    // if (raising edge | falling edge )
    if (currentValue != prevValue ) {
        prevValue = currentValue;
        countsSinceChange = 0;
        switch(currentValue)
        {
            case BUTTON_UP:
                if(!cmd_queue.full())  cmd_queue.push(1);
                pressButtonUp();
                break;
            case BUTTON_DOWN:
                if(!cmd_queue.full())  cmd_queue.push(2);
                pressButtonDown();
                break;
            case BUTTON_MODE:
                if(!cmd_queue.full())  cmd_queue.push(3);
                pressButtonMode();
                break;
            case BUTTON_SET:
                if(!cmd_queue.full())  cmd_queue.push(4);
                pressButtonSet();
                break;
            case BUTTON_CLEAR:
                if(!cmd_queue.full())  cmd_queue.push(5);
                pressButtonClear();
                break;
            case NO_BUTTON:
                if(!cmd_queue.full())  cmd_queue.push(0);
                releaseButton();
                break;
            default:
                /* no action */
                printf("!!!Button Pressed:%d\n\r",currentValue);
                break;
        }
    }
    else
    {   //TODO: play with time for what is short or long hold
        countsSinceChange++;
        if ( currentValue != NO_BUTTON && countsSinceChange>=100000)
        {
            if (isHeld != 2) printf("Button Long Held:%d\n\r",currentValue);
            isHeld = 2;
        }
        else if (currentValue != NO_BUTTON && countsSinceChange>=50000)
        {
            if (isHeld != 1) printf("Button Short Held:%d\n\r",currentValue);
            isHeld = 1;
        }
        else
        {
            isHeld =0;
        }
    }
     
}




void ButtonController::update(void)
{        
    currentValue = spi_io_exp->readGpioPort() ;
    currentValue = (~currentValue & 0x1F); // clear bit is stuck
    
    // if (raising edge | falling edge )
    if (currentValue != prevValue ) {
        prevValue = currentValue;
        countsSinceChange = 0;
        
        if (currentValue && !cmd_queue.full())  {
            cmd_queue.push(currentValue);
            //printf("!!Button Pressed:%d\n\r",currentValue);
        }
        
    }
}


void ButtonController::pressButtonUp(void)
{
    printf("Up Button Pressed:%d\n\r",currentValue);
    if (navigator) 
        navigator->moveUp();
}

void ButtonController::pressButtonDown(void)
{
    printf("Down Button Pressed:%d\n\r",currentValue);
    if (navigator) 
    navigator->moveDown();
}

void ButtonController::pressButtonSet(void)
{
    printf("Set Button Pressed:%d\n\r",currentValue);
    if (navigator) 
        navigator->selectMenu();
}

void ButtonController::pressButtonMode(void)
{
    printf("Mode Button Pressed:%d\n\r",currentValue);
}

void ButtonController::pressButtonClear(void)
{
    printf("Clear Button Pressed:%d\n\r",currentValue);
}

void ButtonController::releaseButton(void)
{
    //printf("Button Released:%d\n\r",currentValue);
    isHeld = 0;
    countsSinceChange = 0;
}
