#include "Stopwatch.h"
#include "mbed.h"

Stopwatch::Stopwatch() {
    // constructor
}

Stopwatch::~Stopwatch() {
    // destructor
}

void Stopwatch::start() {
    // Start the timer
    sw.start();
}

void Stopwatch::stop() {
    // Stop the timer
    sw.stop();
}

void Stopwatch::reset() {
    // Reset the timer
    sw.reset();
}

char* Stopwatch::getTime() {
    // Convert time in milliseconds to 00:00:00 format for output to LCD
    // Returns a pointer to a 8 char array in time format
    ms = sw.read_ms();
    sec = (ms/1000);
    ms = ms - (sec*1000);
    min = (sec/60);
    sec = sec - (min*60);
    ms = (ms/10);
    sprintf(buffer1, "%02d:%02d:%02d", min, sec, ms);
    return buffer1;
}

char* Stopwatch::getTimeFshort() {
    // Convert time in milliseconds to 0:00:0 format for output to LCD
    // Returns a pointer to a 6 char array in time format
    ms1 = sw.read_ms();
    sec = (ms1/1000);
    ms1 = ms1 - (sec*1000);
    min = (sec/60);
    sec = sec - (min*60);
    ms1 = (ms1/100);
    sprintf(buffer2,"%1d:%02d:%1d", min, sec, ms1);
    return buffer2;
}