#include "mbed.h"
#include "PinDetect.h"
#include "stdlib.h"
#include "TextLCD.h"

#define ulow 3.3        //definiere Symbolische Konstante für ulow mit dem Wert xx
#define u_shutdown 3.1    //Konstante für shutdown bei zu geringer Akkuspannung muss immer kleiner als charge4 sein!!!
#define charge1 4
#define charge2 3.7
#define charge3 3.4
#define charge4 3.2

Timer timer1;
Timer t;
TextLCD lcd(p34, p23, p36, p15, p16, p35); // rs, e, d0-d3 für 130110-1P1
PinDetect pb1(p18); //Buzzer
PinDetect pb2(p19); //LED-Button
DigitalIn dip0(p26);    //Hex-Schalter Pin 1 LSB
DigitalIn dip1(p27);    //Hex-schalter Pin 2
DigitalIn dip2(p28);    //Hex-schalter Pin 3
DigitalIn dip3(p29);    //Hex-Schalter Pin 4 MSB
//Serial hm(p13, p14); // definiere UART fuer HM-TPR433 Modul LPC1768
Serial hm(p9, p10); // definiere UART fr HM-TPR433 Modul LPC11U24
DigitalOut config(p22);
DigitalOut enable(p21);
DigitalOut stoppled(p25); //LED-Button
DigitalOut kill(p8);
DigitalOut suspend_charge(p7); //enables LION Charger suspend mode
DigitalOut highpower_charge(p6); // high- 100% charge current, low- 20% charge current
DigitalOut ChargeLed1(LED1);
DigitalOut ChargeLed2(LED2);
DigitalOut ChargeLed3(LED3);
DigitalOut ChargeLed4(LED4);
AnalogIn ubat(p17);
AnalogIn charge_current(p20);

Ticker time1;
Ticker timelong;

int volatile count=0;
int volatile resetcnt=0;
int volatile zz1=0;
int volatile zz2=0;
int volatile sblock=0;
int volatile reset=0;
int volatile D=1;
int volatile j=0;

int ms;
int sec;
int min;
int ms1;

int firsthit=1;

int empfangi=0;

int debug=0;
int timerwert=0;

float u_akku=0;



char buffer[9];
char buffer1[9];
char temp[20];

char zwischenzeit[9];
char zwischenzeit1[9];

char transmit=0;


/*Funktions Dekleration*/

void konfiguration(void)
{
 config = 0;
 enable = 0;
 wait(0.1);
 
/*******Standardkonfiguration laden*******/ 
 hm.putc(0xAA);                    /******/ 
 hm.putc(0xFA);                    /******/ 
 hm.putc(0xF0);                    /******/ 
/*****************************************/ 

wait(0.1);

if((dip0 == 1) && (dip1 == 1) && (dip2 == 1) && (dip3 == 1))   
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xCF); hm.putc(0xD1); hm.putc(0x90);  //HEX-Schalter 0 
 }
 else if((dip0 == 0) && (dip1 == 1) && (dip2 == 1) && (dip3 == 1))
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xD1); hm.putc(0x58); hm.putc(0x30);   //HEX-Schalter 1 
 }
  else if((dip0 == 1) && (dip1 == 0) && (dip2 == 1) && (dip3 == 1))
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xD2); hm.putc(0xDE); hm.putc(0xD0);   //HEX-Schalter 2
 }
  else if((dip0 == 0) && (dip1 == 0) && (dip2 == 1) && (dip3 == 1)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xD4); hm.putc(0x65); hm.putc(0x70);   //HEX-Schalter 3
 }
  else if((dip0 == 1) && (dip1 == 1) && (dip2 == 0) && (dip3 == 1)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xD5); hm.putc(0xEC); hm.putc(0x10);   //HEX-Schalter 4
 }
  else if((dip0 == 0) && (dip1 == 1) && (dip2 == 0) && (dip3 == 1))
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xD7); hm.putc(0x72); hm.putc(0xB0);   //HEX-Schalter 5
 }
  else if((dip0 == 1) && (dip1 == 0) && (dip2 == 0) && (dip3 == 1)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xD8); hm.putc(0xF9); hm.putc(0x50);   //HEX-Schalter 6 
 }
  else if((dip0 == 0) && (dip1 == 0) && (dip2 == 0) && (dip3 == 1)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xDA); hm.putc(0x7F); hm.putc(0xF0);   //HEX-Schalter 7 
 }
  else if((dip0 == 1) && (dip1 == 1) && (dip2 == 1) && (dip3 == 0))
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xDC); hm.putc(0x06); hm.putc(0x90);   //HEX-Schalter 8 
 }
  else if((dip0 == 0) && (dip1 == 1) && (dip2 == 1) && (dip3 == 0))
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xDD); hm.putc(0x8D); hm.putc(0x30);   //HEX-Schalter 9 
 }
  else if((dip0 == 1) && (dip1 == 0) && (dip2 == 1) && (dip3 == 0))
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xDF); hm.putc(0x13); hm.putc(0xD0);   //HEX-Schalter A
 }
  else if((dip0 == 0) && (dip1 == 0) && (dip2 == 1) && (dip3 == 0)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xE0); hm.putc(0x9A); hm.putc(0x70);   //HEX-Schalter B
 }
  else if((dip0 == 1) && (dip1 == 1) && (dip2 == 0) && (dip3 == 0)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xE2); hm.putc(0x21); hm.putc(0x10);   //HEX-Schalter C
 }
  else if((dip0 == 0) && (dip1 == 1) && (dip2 == 0) && (dip3 == 0)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xE3); hm.putc(0xA7); hm.putc(0xB0);   //HEX-Schalter D
 }
  else if((dip0 == 1) && (dip1 == 0) && (dip2 == 0) && (dip3 == 0)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xE5); hm.putc(0x2E); hm.putc(0x50);   //HEX-Schalter E
 }
  else if((dip0 == 0) && (dip1 == 0) && (dip2 == 0) && (dip3 == 0)) 
 {
 hm.putc(0xAA);hm.putc(0xFA);hm.putc(0xD2);hm.putc(0x19); hm.putc(0xE6); hm.putc(0xB4); hm.putc(0xF0);  //HEX-Schalter F
 }
 else
 {
stoppled=1;
 }
 wait(0.1);

/*******Reading the current Config parameter*******/ 
/*hm.putc(0xAA);                     
 hm.putc(0xFA);                    
 hm.putc(0xE1); 
*/
// wait(0.1);
 config = 1;
 enable = 0;
 return; 
}

void stoppuhr(void)
{
    ms = t.read_ms();           //hole mir den TimerWert in ms
    sec = (ms/1000);            //erzeuge mir durch division eine sekunde - aktueller Timerwert/1000 - z.b: 2548/1000=2sec
    ms = ms - (sec*1000);       //stelle meine ms richtig
    min = (sec/60);             //erzeuge mir Minuten
    sec = sec - (min*60);       //stelle Sekunden richtig
    ms = (ms/10);
    ms1 = (ms/10);
                                  //erzeuge mir zwei Stellen nach komma
    sprintf(buffer, "%02d:%02d:%02d", min, sec, ms);            //schreibe in den buffer
    return;
}

void starten(void)              // Callback routine is interrupt activated by a debounced pb1 hit
{

    if ((resetcnt==0) && (sblock==0)) {
        t.reset();                                  //restiere Timer
        t.start();                                  //starte Timer
        resetcnt=1;
        enable = 0;                                 //schalte das RF-Modul ein
        firsthit=0;                                 //verhindert ein erhöhen der Variable sblock durch wiederholtes drücken des Buzzers.
    } else if ((resetcnt==1) && (sblock==0)) {
        zz1=1;
        sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
        lcd.locate(0, 1);
        lcd.printf("A%s", zwischenzeit);
        resetcnt=2;
    } else if ((resetcnt==2) && (sblock==0)) {
        zz2=1;
        sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
        lcd.locate(8, 1);
        lcd.printf("B%s", zwischenzeit1);
        resetcnt=3;
    } else { //nach hundert mal drueken wieder auf restcnt auf 3 setzen - SIcherheitsmechanismus um Integerüberlauf zu vermeiden
        resetcnt=resetcnt++;
        if(resetcnt==100) {
            resetcnt=3;
        }
    }
    resetcnt=resetcnt++;
}

void sendkill (void)
{
    enable=0;
    wait(0.1);
    hm.putc(0);
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('q');
    wait(0.1);
    hm.putc(0);
}

void sendreset(){
    enable=0;
    wait(0.1);
    hm.putc(0);
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('x');
    wait(0.1);
    hm.putc(0);
    enable=0;
    return;
}

void sendstart(){
    starten();
    transmit=1;
    enable=0;
    wait(0.1);
    hm.putc(0);
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('g');
    wait(0.1);
    hm.putc(0);
    enable=0;
    transmit=0;
    return;
}

void sendstop(){
    enable=0;
    wait(0.1);
    hm.putc(0);
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc('s');
    wait(0.1);
    hm.putc(0);
    enable=0;
    return;
} 

void kill_modul(void)
{
    lcd.cls();
    lcd.printf("   shut down");
    
    sendkill();
    
    wait(3);
    kill=0;
    wait (0.1);
    return;
}  

void reset_startbutton( void )
{
    if(sblock==1) { // Reset für Durchgang erhöhen
        t.stop();
        t.reset();
        memset(buffer1,0,19);
        stoppuhr();
        //sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
        //sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
        resetcnt=0;
        zz1=0;
        zz2=0;
        sblock=0;
        D++;
        firsthit=1;
        lcd.cls();
        
        sendreset();

        if(D>99) {
            D=1;
        }
    }
 } 
 
void totalreset_local (void)
{
        t.stop();
        t.reset();
        stoppuhr();
        memset(buffer1,0,19);
        //sprintf(zwischenzeit,"%01d:%02d:%1d", min, sec, ms1);
        //sprintf(zwischenzeit1,"%01d:%02d:%1d", min, sec, ms1);
        resetcnt=0;
        zz1=0;
        zz2=0;
        sblock=0;
        D=1;
        firsthit=1;
        time1.detach();
        lcd.cls();
}  

void stoppen (void)        //Stoppen des Timers ohne Funk
{
    t.stop();
    if (firsthit==0){
    sblock=1;
    }
}

void stoppled_blink()    {
    stoppled=!stoppled;
    return;
}        

void akkucheck()
{
    if (transmit==0){
        float i=0;
        
            for(int t=0; t<100; t++) {
                i=i+ubat.read();
            }
           // 100x ubat ADC Wert abfragen und in i aufsummieren um mittels Mittelwertbildung genaueres Ergebnis zu erziehlen
    
            u_akku=((i/100)*4.364);
            
            //lcd.locate(0, 1);  //debug Ausgabe
            //lcd.printf("Akkucheck %3.2fV", u_akku); //debug Ausgabe
            //wait(0.1);  //debug Ausgabe
            
           if(u_akku<=ulow) { //wenn Batteriespannung kleiner als ulow dann Akku laden am LCD ausgeben
            lcd.cls();

            lcd.locate(6,0);
            lcd.printf("%3.2fV", u_akku);
            lcd.locate(3,1);
            lcd.printf("Akku laden!");
            wait(3);
            lcd.cls();
        }
            /*if(u_akku>ulow) {             
                time1.attach(&stoppled_blink,2);
                
                
            }
            if(u_akku<=ulow) {             
                time1.attach(&stoppled_blink,0.5);
               
            }*/
            if(u_akku>=charge1) {
                ChargeLed1=1;
                ChargeLed2=1;
                ChargeLed3=1;
                ChargeLed4=1;
                time1.attach(&stoppled_blink,2);
                }
            
                else if(u_akku>=charge2) {
                    ChargeLed1=1;
                    ChargeLed2=1;
                    ChargeLed3=1;
                    ChargeLed4=0;
                    time1.attach(&stoppled_blink,2);
                }
                else if(u_akku>=charge3) {
                    ChargeLed1=1;
                    ChargeLed2=1;
                    ChargeLed3=0;
                    ChargeLed4=0;
                    time1.attach(&stoppled_blink,2);
                }
                else if(u_akku>=charge4) {
                    ChargeLed1=1;
                    ChargeLed2=0;
                    ChargeLed3=0;
                    ChargeLed4=0;
                    time1.attach(&stoppled_blink,0.5);
                }
                else if (u_akku<=u_shutdown) {       
                    time1.detach();
                    stoppled=0;
                    wait(3);
                    kill_modul();
                }
            
            }
            
                
        return;
  // }
} 

void empfangen()
{
    //Funktion wird aufgerufen sobald das RF-Modul Daten an TX hat - über die Interruptroutine hm.attach(&empfangen) springe ich in die Funktion
    //Beim konfigurieren des Funkmoduls werden Uart Interrupts ausgelöst, diese werden durch die folgende while schleife abgefangen
    //Funkmodul schickt anscheinend 4 char nach der Konfiguration

    /*    while (j<4) {
            j=j+1;
            hm.getc();
            return;
        }*/
    int i=0;
    
    if (hm.readable()) {
        temp[empfangi] = hm.getc();
        empfangi++;

         if (temp[empfangi-1]==0) {
                temp[empfangi]=0;
                empfangi=0;
                i=0;

         if (temp[0]=='s' && temp[1]=='s' && temp[2]=='q') {     //Kommandos werden mit zwei 's' characters eingeleitet der dritte character definiert das Kommando
                kill_modul();
            } else if (temp[0]=='s' && temp[1]=='s' && temp[2]=='s') {
                stoppen();
            } else if (temp[0]=='s' && temp[1]=='s' && temp[2]=='x') {
                reset_startbutton();
            } else if (temp[0]=='s' && temp[1]=='s' && temp[2]=='t') {
                totalreset_local();
            } else if (temp[0]=='s' && temp[1]=='s' && temp[2]=='e') {      //mit Kommando 'e' kann Text übertragen werden
                
                 
                for (int z=3; temp[z]!=0; z++)
                   // lcd.printf("%c", temp[z]);
                   {buffer1[i]=temp[z];
                   i++;
                   }
                   buffer1[i]=0;
                   
                    //lcd.locate(4,1);
                    //lcd.printf("Z1:%s",buffer1);
                memset(temp,0,19);
                    //lcd.locate(4,0);
                    //lcd.printf("Zx:%s",buffer1);
            }
        }

    }
    return;
}

/*Funktion zur Anzeige der Batteriespannung am LCD.******
**Unterhalb der Spannung "ulow" wird eine Aufforderung***
** zum Batterietausch ausgegeben.************************/
void lowbatt()
{
    float i=0;

    for(int t=0; t<100; t++) {
        i=i+ubat.read();
    } // 100x ubat ADC Wert abfragen und in i aufsummieren um mittels Mittelwertbildung genaueres Ergebnis zu erziehlen

    u_akku=((i/100)*4.364);
    if(u_akku>=ulow) {
        lcd.cls();

        //lcd.setUDC(unsigned char udc_Bat_Hi[],{0x0E, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00});

        lcd.printf("  Akkuspannung");
        lcd.locate(5,1);
        lcd.printf("%3.2fV",u_akku); // Ausgabe der Akkuspannung
        wait(2);
        lcd.cls();

    }
    if(u_akku<=ulow) { //wenn Batteriespannung kleiner als ulow dann Akku laden am LCD ausgeben
        lcd.cls();

        lcd.locate(6,0);
        lcd.printf("%3.2fV", u_akku);
        lcd.locate(3,1);
        lcd.printf("Akku laden!");
        wait(3);
        lcd.cls();

    }
    if (u_akku<=u_shutdown) {
        kill_modul();
    }
    return;
}
  
int main() 
{ 
   kill=1;
    suspend_charge=0; 
    highpower_charge=1;
     
                    
    pb1.mode(PullDown); // Use internal pulldown for pushbutton
    pb2.mode(PullNone); // keinen Modus verwenden 
    dip0.mode(PullUp);  // Use internal pullup for heX-switch - on LPC1768 you need also hardware pull up resistor
    dip1.mode(PullUp);  // Use internal pullup for heX-switch - on LPC1768 you need also hardware pull up resistor
    dip2.mode(PullUp);  // Use internal pullup for heX-switch - on LPC1768 you need also hardware pull up resistor
    dip3.mode(PullUp);  // Use internal pullup for pushbutton - on LPC1768 you need also hardware pull up resistor
    
    wait(0.01); // Delay for initial pullup to take effect
   
    konfiguration(); //RF Modul konfigurieren
    
    lowbatt(); //Batteriespannung beim Start abfragen
     
    pb1.attach_asserted(&sendstart);
    pb1.attach_asserted_held(&reset_startbutton);
    
    pb2.attach_asserted(&sendstop);
    pb2.attach_deasserted_held(&kill_modul); // Setup Interrupt callback functions for a pb hit
    
    pb1.setSampleFrequency();
    
    pb2.setSampleFrequency();
    
    pb2.setSamplesTillHeld( 200 );
    
    hm.attach(&empfangen,Serial::RxIrq);  // Setup Interrupt callback functions for Datareceive
    timelong.attach(&akkucheck,60); //Akkutest wird alle 60sec. gestartet
    
    lcd.cls();  //debug Ausgabe                    
    lcd.printf("   Starttaster");   //debug Ausgabe        
    wait(2);
    
    time1.attach(&stoppled_blink,2);
    timer1.start();
    lcd.cls();
    
    memset (buffer,0,19);
    memset (buffer1,0,19);
    while (1) { 
        wait(.1);
        //lcd.cls();
        stoppuhr();                     //rufe Funktion stoppuhr auf
        lcd.locate(0, 0);               //setze den Cursor auf Zeichen 0 Reihe 1
        lcd.printf("D%02d", D);         // Ausgabe der Durchgänge, Formatiere mein LCD-Ausgabe nach D00 (zwei stellen)
        lcd.locate(4, 0);
        if (buffer1[1]!=0) {
           // if (strlen(buffer1)>0) {
            //lcd.printf("ZE:%c%c%c%c%c%c%c%c",buffer1[0],buffer1[1],buffer1[2],buffer1[3],buffer1[4],buffer1[5],buffer1[6],buffer1[7]);
            lcd.printf("ZE:%s",buffer1);
            //} else {
             //   lcd.printf("pussy %d ",debug);
              //  }
            } else if (buffer[1]!=0){
                lcd.printf("ZE:%s",buffer);
                }
            
        //lcd.locate(4, 1);
        //lcd.printf("ZE:%s", temp);
                                       
  }
 
}
