/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 */
#include "tricolor.h"

#define ON 255
#define OFF 0

void Tricolor::Blue(void) {
    SetLEDColor(OFF, OFF, ON);
}

void Tricolor::Green(void) {
    SetLEDColor(OFF, ON, OFF);
}

void Tricolor::LEDOff(void) {
    // Off == 1.0
    _Red = 1.0;
    _Green = 1.0;
    _Blue = 1.0;
    _on = false;
}

void Tricolor::LEDOn(void) {
    _Red = _RedPwm;
    _Green = _GreenPwm;
    _Blue = _BluePwm;
    _on = true;
}

void Tricolor::Red(void) {
    SetLEDColor(ON, OFF, OFF);
}

void Tricolor::SetLEDColor(uint8_t red, uint8_t green, uint8_t blue) {
    _RedPwm = 1.0 - ((float)red / 255);
    _GreenPwm = 1.0 - ((float)green / 255);
    _BluePwm = 1.0 - ((float)blue / 255);
    
    LEDOn();
}

void Tricolor::Toggle(void) {
    if (_on) {
        LEDOff();
    } else {
        LEDOn();
    }
}
