#include "mbed.h"
#include "PinDetect.h"

// Objects
DigitalOut myLed(LED1);
DigitalOut solenoid(p6);
PinDetect button(p5);
Timer timer;

// Primitives
int timeInMinutes = 25; // Timer is only good to about 30 mins!
float halfSecond = 0.5; // LED blink rate

// Interrupt function for start/stop button
//////////////////////////////////////////////////
void StartStop() {
    // Enabled = !Enabled
    if(solenoid.read()) {
        // Turn off
        timer.stop();
        solenoid = false;
    } else {
        // Turn on
        timer.reset();
        timer.start();
        solenoid = true;
    }
}

// Main loop
//////////////////////////////////////////////////
int main() {
    // Set button interrupt w/PullDown and debounce
    button.mode(PullDown);
    button.attach_asserted_held(&StartStop);
    button.setSampleFrequency(9);
    
    // Infinite loop
    while(true) {
        // Stop if time(s) > n Mins(m) * 60(s)
        if(timer.read() > timeInMinutes * 60) {
            solenoid = false;
            timer.stop();
        }
        
        // Slow pulse status LED when enabled
        if(solenoid.read())
            myLed = !myLed.read();
        else
            myLed = false;
        
        // Wait so LED pulses
        wait(halfSecond);
    }
}
