#include "mbed.h"

Serial STN(p28, p27);
Serial pc(USBTX, USBRX);

long STNBAUD = 9600;
long PCBAUD = 38400;

void flushSerialBuffer(Serial *port);

int main() {
    // Configure PC BAUD
    pc.baud(PCBAUD);
    
    // Setup STN1110 UART
    pc.printf("Configuring STN UART\r\n");
    STN.baud(STNBAUD);
    
    // Get to a prompt
    bool prompt = false;
    while(!prompt) {
        // Attempt communication
        pc.printf("STN not ready\r\n");
        STN.printf("\r");
        wait(1);
    
        // Did we get a prompt?
        while (STN.readable()) {
            if (STN.getc() == '>') {
                prompt = true;
                flushSerialBuffer(&STN);
            }
        }
    }
  
    // Attempt BAUD rate change
    STN.printf("ATZ\r");
    pc.printf("STN BAUD == %d\r\n", STNBAUD);
    
    // Start terminal communication
    while(1) {
        if(STN.readable()) {
            char c = STN.getc();
            pc.putc(c);
            if (c == '\r')
                pc.putc('\n');
        }
        if(pc.readable()) {
            char c = pc.getc();
            STN.putc(c);
        }
    }
}

// Clears the Serial port buffer so we can get to new messages
void flushSerialBuffer(Serial *port) {
    while ((*port).readable()) {
        (*port).getc();
    }
    return;
}
