#include "mbed.h"
#include "SD_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include "LogoBitmap.h"
 
SD_DISCO_F469NI sd;
LCD_DISCO_F469NI lcd;
Serial pc(USBTX, USBRX);

#define LOGO_START_ADDR 0
#define LOGOSMALL_START_ADDR 1536000
#define IDLE_START_ADDR 1576960
#define GEAR1_START_ADDR 1966080
#define GEAR2_START_ADDR 2355200
#define GEAR3_START_ADDR 2744320
#define GEAR4_START_ADDR 3133440
#define GEAR5_START_ADDR 3522560
#define GEAR6_START_ADDR 3911680

const uint32_t LogoHeight=380;
const uint32_t LogoWidth=256;
uint32_t LogoMemory=LogoHeight*LogoWidth*4;
uint32_t auxBuffer[128];
uint32_t StartXPos=0;
uint32_t StartYPos=0;

void WriteLogo(SD_DISCO_F469NI sd);
void PrintGear(uint32_t Gear);

int main(){
    
    uint8_t SD_state = MSD_OK;
    pc.printf("SD\n");
    SD_state = sd.Init();
    if(SD_state != MSD_OK){
        if(SD_state == MSD_ERROR_SD_NOT_PRESENT){
            pc.printf("SD shall be inserted before running test\n");
        } else {
            pc.printf("SD Initialization : FAIL.\n");
        }
        pc.printf("SD Test Aborted.\n");
    } else {
        pc.printf("SD Initialization : OK.\n");
    };    
    
    PrintGear(IDLE_START_ADDR);
    wait(0.5);
    PrintGear(GEAR1_START_ADDR);
    wait(0.5);
    PrintGear(GEAR2_START_ADDR);
    wait(0.5);
    PrintGear(GEAR3_START_ADDR);
    wait(0.5);
    PrintGear(GEAR4_START_ADDR);
    wait(0.5);
    PrintGear(GEAR5_START_ADDR);
    wait(0.5);
    PrintGear(GEAR6_START_ADDR);
    wait(0.5);
    
    while(1){
    };
};

void WriteLogo(SD_DISCO_F469NI sd){
    uint32_t p,q;
    uint32_t BlockBuffer[128];
    for (p=0;p<760;p++){
        for(q=0;q<128;q++){
            BlockBuffer[q]=LogoBitmap[p*128+q];
            //pc.printf("Blockbuffer[%d]=%x\n",q,BlockBuffer[q]);
        };       
        if(sd.WriteBlocks(BlockBuffer,GEAR1_START_ADDR+p*512,1,SD_DATATIMEOUT)!=MSD_OK){
            pc.printf("Blockbuffer copy to SD failed.");
        };
        pc.printf("BlockBuffer %d\n",p);
    };
    pc.printf("Bitmap copied to SD");
};



void PrintGear(uint32_t Gear){
    uint32_t p,q;
    uint32_t BlockBuffer[128];
    uint16_t xpos=0,ypos=0;
    for(p=0;p<760;p++){
        sd.ReadBlocks(BlockBuffer,Gear+p*512,1,SD_DATATIMEOUT);
        for(q=0;q<128;q++){
            if(ypos<LogoHeight){
               lcd.DrawPixel(StartXPos+xpos,StartYPos+ypos,BlockBuffer[q]);
            }
            else{
                xpos++;
                ypos=0;
                lcd.DrawPixel(StartXPos+xpos,StartYPos+ypos,BlockBuffer[q]);
            }
            ypos++;
        }
        //wait(0.005);
    }
};  