#include "Gear.h"
#include "mbed.h"
#define BYTE_TO_BINARY_PATTERN "%c%c%c%c%c%c%c%c"
#define BYTE_TO_BINARY(byte)\
  (byte & 0x80 ? '1' : '0'),\
  (byte & 0x40 ? '1' : '0'),\
  (byte & 0x20 ? '1' : '0'),\
  (byte & 0x10 ? '1' : '0'),\
  (byte & 0x08 ? '1' : '0'),\
  (byte & 0x04 ? '1' : '0'),\
  (byte & 0x02 ? '1' : '0'),\
  (byte & 0x01 ? '1' : '0')

extern LCD_DISCO_F469NI lcd;
const uint32_t StartXPos=330;
const uint32_t StartYPos=70;


GEAR Gear1={160,328,GearBitmap1};
/* GEAR Gear2 {0,0,GearBitmap2};
GEAR Gear3 {0,0,GearBitmap3};
GEAR Gear4 {0,0,GearBitmap4};
GEAR Gear5 {0,0,GearBitmap5};
GEAR Gear6 {0,0,GearBitmap6};
*/


void PrintGear(GEAR Gear){
    uint32_t width=Gear.width;
    uint32_t height=Gear.height;
    uint32_t horpos,vertpos;
    uint8_t bitloc;
    char pos[50];
    //uint8_t dbg[50];
    for(vertpos=0;vertpos<height;vertpos++){
        for(horpos=0;horpos<width/8;horpos++){
            sprintf(pos,BYTE_TO_BINARY_PATTERN,BYTE_TO_BINARY(Gear.GearBitmap[vertpos*(width/8)+horpos]));
            for(bitloc=0;bitloc<8;bitloc++) {
                if (pos[bitloc]=='1') {
                    lcd.DrawPixel(StartXPos+horpos*8+bitloc,StartYPos+vertpos,0xFFF00000);
                    //wait_us(50);
                    //lcd.FillRect(StartXPos,StartYPos,StartXPos+horpos,StartYPos+vertpos);
               }
            }
        }
    }
    
};