#include "LCD_DISCO_F469NI.h"
#include "SD_DISCO_F469NI.h"

#define PI  3.14159265358979323846
#define BYTE_TO_BINARY_PATTERN "%c%c%c%c%c%c%c%c"
#define BYTE_TO_BINARY(byte)\
  (byte & 0x80 ? '1' : '0'),\
  (byte & 0x40 ? '1' : '0'),\
  (byte & 0x20 ? '1' : '0'),\
  (byte & 0x10 ? '1' : '0'),\
  (byte & 0x08 ? '1' : '0'),\
  (byte & 0x04 ? '1' : '0'),\
  (byte & 0x02 ? '1' : '0'),\
  (byte & 0x01 ? '1' : '0')

#define LOGOBIG_START_ADDR 0
#define LOGOSMALL_START_ADDR 1536000

const double PHI=53.13010235*PI/180;
const double ALPHA=73.73979529*PI/180;
const double Vmax=150;

const uint16_t GearXPos=272,GearYPos=95;
const uint16_t OilTempXPos=15,OilTempYPos=200;
const uint16_t LogoSmallXPos=635,LogoSmallYPos=5;
const uint16_t WaterTempXPos=15,WaterTempYPos=350;
const uint16_t TPSXPos=569,TPSYPos=200;
const uint16_t OilPXPos=330,OilPYPos=25;
const uint16_t MAPXPos=330,MAPYPos=100;
const uint16_t AirTempXPos=330,AirTempYPos=175;
const uint16_t LambdaXPos=330,LambdaYPos=250;
const uint16_t VoltsXpos=330,VoltsYPos=325;
const uint16_t CrankXPos=330,CrankYPos=400;
//Za YPos pocetna pozicija je tacka na dnu, ne na vrhu jer se bar puni na gore.
const uint16_t FLLVDTBarXPos=280,FLLVDTBarYPos=200;
const uint16_t FRLVDTBarXPos=440,FRLVDTBarYPos=200;
const uint16_t BLLVDTBarXPos=280,BLLVDTBarYPos=410;
const uint16_t BRLVDTBarXPos=440,BRLVDTBarYPos=410;
const uint16_t FLLVDTXPos=50,FLLVDTYPos=100;
const uint16_t FRLVDTXPos=534,FRLVDTYPos=100;
const uint16_t BLLVDTXPos=50,BLLVDTYPos=310;
const uint16_t BRLVDTXPos=534,BRLVDTYPos=310;


typedef struct BWImage{
    char name;
    uint16_t width;
    uint16_t height;
    uint8_t *bitmap;
    } GEAR,CHAR;

typedef struct RGBImage{
    uint16_t width;
    uint16_t height;
    uint32_t START_ADDR;
    }IMAGE;

void DrawSpeedMeter();
void PrintChar(CHAR Char,uint16_t StartXPos,uint16_t StartYPos,uint32_t TextColor);
void PrintString(char str[],int font,uint16_t StartXPos,uint16_t StartYPos,uint32_t TextColor);
void ChangeNumber(int num,int num0,int Font,uint16_t StartXPos,uint16_t StartYPos);
void DrawRGBImage(IMAGE Image,uint16_t StartXPos,uint16_t StartYPos);
void UpdateSpeedMeter(int V,int dV);
void UpdateLVDTScale(int D,int D0, uint16_t StartXPos, uint16_t StartYPos);
void BrakeSignal(int brake,int brake0);
void TestFont();
